#ifndef ISOCELE_H
#define ISOCELE_H

#include "Screen.h"
#include "Sprite.h"

class Isocele:public Sprite
{
public:
    Isocele(Screen* mScreen,UINT16 xc,UINT16 yc,UINT16 radius,int orientation,float _speed,Color color);
    //
    virtual void draw(void);
    //
    virtual ~Isocele(void);
    //
    void setOrientation(int _orientation);
    //
    void turnLeft(void);
    //
    void turnRight(void);
    //
    void setInvisible(bool _state);
    //
    void setNewPosition(INT16 _xcnew,INT16 _ycnew);
    //
    void setNewPosition(INT16 _xcnew,INT16 _ycnew,bool isScreenLimits);
    //
    void update(float delta);
    //
    int getOrientation(void) const;
    //
    UINT16 getXcenter(void) const;
    //
    UINT16 getYcenter(void) const;

    static const int ORIENTATION_UP=0;
    static const int ORIENTATION_LEFT=1;
    static const int ORIENTATION_DOWN=2;
    static const int ORIENTATION_RIGHT=3;

protected:
    UINT16 myXcenter;
    UINT16 myYcenter;
    UINT16 myRadius;
    int myOrientation;

    UINT16 myX1,myY1;
    UINT16 myX2,myY2;
    UINT16 myX3,myY3;
    float mySpeed;

    void updateOrientation(void);
    void myElementUpdate(void);
};
#endif