#include "Isocele.h"

void Isocele::updateOrientation(void)
{
    switch(myOrientation) {
            //
        case Isocele::ORIENTATION_UP:
            mySpeedX=0.0;
            mySpeedY=-mySpeed;

            myX=myXcenter-myRadius;
            myY=myYcenter-myRadius;
            myWidth=myRadius+myRadius;
            myHeight=myRadius;

            myX1=myXcenter;
            myY1=myYcenter-myRadius;

            myX2=myXcenter-myRadius;
            myY2=myYcenter;

            myX3=myXcenter+myRadius;
            myY3=myYcenter;
            break;

            //
        case Isocele::ORIENTATION_RIGHT:
            mySpeedX=mySpeed;
            mySpeedY=0.0;

            myX=myXcenter;
            myY=myYcenter-myRadius;
            myWidth=myRadius;
            myHeight=myRadius+myRadius;

            myX1=myXcenter;
            myY1=myYcenter-myRadius;

            myX2=myXcenter;
            myY2=myYcenter+myRadius;

            myX3=myXcenter+myRadius;
            myY3=myYcenter;
            break;

            //
        case Isocele::ORIENTATION_DOWN:
            mySpeedX=0.0;
            mySpeedY=mySpeed;

            myX=myXcenter-myRadius;
            myY=myYcenter;
            myWidth=myRadius+myRadius;
            myHeight=myRadius;

            myX1=myXcenter-myRadius;
            myY1=myYcenter;

            myX2=myXcenter;
            myY2=myYcenter+myRadius;

            myX3=myXcenter+myRadius;
            myY3=myYcenter;
            break;

            //
        case Isocele::ORIENTATION_LEFT:
            mySpeedX=-mySpeed;
            mySpeedY=0.0;

            myX=myXcenter-myRadius;
            myY=myYcenter-myRadius;
            myWidth=myRadius;
            myHeight=myRadius+myRadius;

            myX1=myXcenter-myRadius;
            myY1=myYcenter;

            myX2=myXcenter;
            myY2=myYcenter+myRadius;

            myX3=myXcenter;
            myY3=myYcenter-myRadius;
            break;

            //
        default:
            break;

    }

}
//--------------------------------------------
Isocele::Isocele(Screen* mScreen,UINT16 xc,UINT16 yc,UINT16 radius,int orientation,float _speed,
                 Color color): 
                 Sprite(mScreen,0,xc-radius,yc-radius,radius+radius,radius,color)
{
    myXcenter=xc;
    myYcenter=yc;
    myRadius=radius;
    myOrientation=orientation;
    mySpeed=_speed;

    updateOrientation();

    myIsUpdateAutomatic=false;

    myType=OBJ_ISOCELE;

    myScreen->addWidget((Widget*) this);
}
//--------------------------------------------
void Isocele::draw(void)
{
    // isVisible ?
    if(myIsVisible==false) {
        return;
    }
    //
    PicasoSerial* ps=0;
    ps=myScreen->getPicasoSerial();

    if(ps!=0) {
        ps->draw_filled_triangle(myX1,myY1,myX2,myY2,myX3,myY3,myColor);
        //
        //ps->draw_rectangle(myX,myY,myX+myWidth,myY+myHeight,BLACK);
    }
    ps=0;
}
//---------------------------------------------
Isocele::~Isocele(void)
{
}
//--------------------------------------------
void Isocele:: setInvisible(bool _state)
{
    // element devient invisible
    if(_state==true) {
        if(myIsVisible==false)
            return;

        myIsVisible=false;

        Color c= myScreen->getColorBkg();

         PicasoSerial* ps=0;
        ps=myScreen->getPicasoSerial();

        if(ps!=0) {
            ps->draw_filled_triangle(myX1,myY1,myX2,myY2,myX3,myY3,c);
            //ps->draw_rectangle(myX,myY,myX+myWidth,myY+myHeight,c);
        }
        ps=0;
    }

    // element devient visible
    else {
        myIsVisible=true;

        this->draw();
    }
}
//------------------------------------------
void Isocele::setNewPosition(INT16 _xcnew,INT16 _ycnew)
{
    setNewPosition(_xcnew,_ycnew,true);
}
//-------------------------------------------
void Isocele::setNewPosition(INT16 _xcnew,INT16 _ycnew,bool isScreenLimits)
{
    if(myIsVisible==false)
        return;
    //
    if(myXcenter==_xcnew && myYcenter==_ycnew)
        return;
    //
    this->setInvisible(true); 

    myIsVisible=true;
if(isScreenLimits)
{

    //test Xmax
    if(_xcnew+myRadius >= myXMoveMax) {
        _xcnew=myXMoveMax-myRadius;

        if(myState==STATE_ON)
            myState=BUMP_RIGHT;
    }

    //test Xmin
    if(_xcnew <= myRadius) {
        _xcnew=myXMoveMin+myRadius;

        if(myState==STATE_ON)
            myState=BUMP_LEFT;
    }
    //test Ymax
    if(_ycnew +myRadius >= myYMoveMax && _ycnew >0) {
        _ycnew = myYMoveMax- myRadius;

        if(myState==STATE_ON)
            myState=BUMP_DOWN;
    }
    //test yminMin;
    if(_ycnew <= myRadius) {
        _ycnew=myYMoveMin+myRadius;

        if(myState==STATE_ON)
            myState=BUMP_UP;
    }
}
    //
    myXcenter=_xcnew;
    myYcenter=_ycnew;

    updateOrientation();

    this->draw();
}
//--------------------------------------------
void Isocele::myElementUpdate(void)
{
    switch(myState) {
            //
        case BUMP_DOWN:
            setInvertSpeedY();
            myState=STATE_ON;
            myOrientation=Isocele::ORIENTATION_UP;
            break;
            //
        case BUMP_LEFT:
            setInvertSpeedX();
            myState=STATE_ON;
            myOrientation=Isocele::ORIENTATION_RIGHT;
            break;
            //
        case BUMP_RIGHT:
            setInvertSpeedX();
            myState=STATE_ON;
            myOrientation=Isocele::ORIENTATION_LEFT;
            break;
            //
        case BUMP_UP:
            setInvertSpeedY();
            myState=STATE_ON;
            myOrientation=Isocele::ORIENTATION_DOWN;
            break;
            //
        case STATE_OFF:
            break;
            //
        default:
            break;
    }
}
//--------------------------------------------
void Isocele::update(float delta)
{
    if(myIsUpdateAutomatic)
        myElementUpdate();
    //
    float xnew=myXcenter+mySpeedX*delta;
    float ynew=myYcenter+mySpeedY*delta;

    this->setNewPosition((INT16)xnew,(INT16)ynew,true);

}
//--------------------------------------------
void Isocele::setOrientation(int _orientation)
{
    myOrientation=_orientation;

}
//--------------------------------------------
int Isocele::getOrientation(void) const
{
    return this->myOrientation;
}
//--------------------------------------------
UINT16 Isocele::getXcenter(void) const
{
    return this->myXcenter;
}
//--------------------------------------------
UINT16 Isocele::getYcenter(void) const
{
    return this->myYcenter;
}
//--------------------------------------------
void Isocele::turnLeft(void)
{
    myOrientation+=1;

    if(myOrientation >Isocele::ORIENTATION_RIGHT)
        myOrientation=ORIENTATION_UP;

}
//--------------------------------------------
void Isocele::turnRight(void)
{
    myOrientation-=1;

    if(myOrientation <Isocele::ORIENTATION_UP)
        myOrientation=ORIENTATION_RIGHT;

}