#include "GraphicLed.h"

GraphicLed::GraphicLed(Screen* mScreen,UINT16 _xc,UINT16 _yc,UINT16 _radius,
                       Color _colorOn,Color _colorOff,State _state):
    Widget(mScreen,0,_xc-_radius,_yc-_radius,_radius+_radius,_radius+_radius,_colorOn)
{
    myColorOn=_colorOn;
    myColorOff=_colorOff;
    myRadius=_radius;
    myCenterX=_xc;
    myCenterY=_yc;

    myState=_state;
    myType=OBJ_LED;
    myScreen->addWidget((Widget*) this);
}
//---------------------------------------
GraphicLed::~GraphicLed(void)
{
}
//---------------------------------------
void GraphicLed::draw(void)
{
    if(myIsVisible==false)
        return;

    UINT16 state=getState();

    PicasoSerial* ps=0;
    ps=myScreen->getPicasoSerial();

    switch(state) {
            //
        case LED_STATE_ON:
            if(ps!=0) {
                ps->draw_filled_circle(myCenterX,myCenterY,myRadius,myColorOn);
                ps->draw_circle(myCenterX,myCenterY,myRadius,BLACK);
                ps=0;
            }
            return;
            //
        case LED_STATE_OFF:
            if(ps!=0) {
                ps->draw_filled_circle(myCenterX,myCenterY,myRadius,myColorOff);
                ps->draw_circle(myCenterX,myCenterY,myRadius,BLACK);
                ps=0;
            }
            return;
            //
        default:
            break;
    }
    
}
//---------------------------------------
void GraphicLed::setInvisible(bool _state)
{
    // element devient invisible
    if(_state==true) {
        if(myIsVisible==false)
            return;

        myIsVisible=false;

        Color c= myScreen->getColorBkg();

        PicasoSerial* ps=0;
        ps=myScreen->getPicasoSerial();

        if(ps!=0) {
            ps->draw_filled_circle(myCenterX,myCenterY,myRadius,c);
        }
        ps=0;
    }

    // element devient visible
    else {
        myIsVisible=true;


        this->draw();
    }
}
//---------------------------------------
void GraphicLed::setState(State _state)
{
    if(myIsVisible==false)
        return;

    if(myState==_state)
        return;

    myState=_state;

    this->draw();
}