#ifndef ELLIPSE_H
#define ELLIPSE_H

#include "Screen.h"
#include "Sprite.h"

class Ellipse:public Sprite
{
public:
    /** Construct a filled Ellipse
    *
    * @param mScreen the pointer screen
    * @params _xc the center x
    * @params _yc the center y
    * @params _radiusX
    * @radius _radiusY
    * @param _color the background color
    */
    Ellipse(Screen* mScreen,UINT16 _xc,UINT16 _yc,UINT16 _radiusX,UINT16 _radiusY,Color _color);
    //
    virtual void draw(void);
    //
    virtual ~Ellipse(void);
    //
    void update(float delta);

// getter
    UINT16 getCenterX(void) const;
    //
    UINT16 getCenterY(void) const;

//setter
    void setInvisible(bool _state);
    //
    void setNewPosition(INT16 _xcnew,INT16 _ycnew);
    //
    void setNewPosition(INT16 _xcnew,INT16 _ycnew,bool isScreenLimits);
    //
    void setCenterX(UINT16 _xcenter);
    //
    void setCenterY(UINT16 _ycenter);


protected:
    UINT16 myCenterX;
    UINT16 myCenterY;
    UINT16 myRadiusX;
    UINT16 myRadiusY;
};

#endif