#include "Ellipse.h"

Ellipse::Ellipse(Screen* mScreen,UINT16 _xc,UINT16 _yc,UINT16 _radiusX,UINT16 _radiusY,Color _color):
    Sprite(mScreen,0,_xc-_radiusX,_yc-_radiusY,_radiusX+_radiusX,_radiusY+_radiusY,_color)
{
    myCenterX=_xc;
    myCenterY=_yc;
    myRadiusX=_radiusX;
    myRadiusY=_radiusY;

    myType=OBJ_ELLIPSE;

    myScreen->addWidget((Widget*) this);
}
//----------------------------------------------
void Ellipse::draw(void)
{
    // isVisible ?
    if(myIsVisible==false) {
        return;
    }
    //
    PicasoSerial* ps=0;
    ps=myScreen->getPicasoSerial();

    if(ps!=0) {
        ps->draw_filled_ellipse(myCenterX,myCenterY,myRadiusX,myRadiusY,myColor);
    }
    ps=0;
}
//----------------------------------------------
void Ellipse::update(float delta)
{
    if(myIsUpdateAutomatic)
        elementUpdate();

    float xcnew=myCenterX+mySpeedX*delta;
    float ycnew=myCenterY+mySpeedY*delta;

    this->setNewPosition((INT16)xcnew,(INT16)ycnew,true);

}
//-----------------------------------------------
void Ellipse::setInvisible(bool _state)
{
    // element devient invisible
    if(_state==true) {
        if(myIsVisible==false)
            return;

        myIsVisible=false;

        Color c= myScreen->getColorBkg();

        PicasoSerial* ps=0;
        ps=myScreen->getPicasoSerial();

        if(ps!=0) {
            ps->draw_filled_ellipse(myCenterX,myCenterY,myRadiusX,myRadiusY,c);
        }
        ps=0;
    }

    // element devient visible
    else {
        myIsVisible=true;


        this->draw();
    }
}
//-----------------------------------------------
void Ellipse::setNewPosition(INT16 _xcnew,INT16 _ycnew)
{
    setNewPosition(_xcnew,_ycnew,true);
}
//-----------------------------------------------
void Ellipse::setNewPosition(INT16 _xcnew,INT16 _ycnew,bool isScreenLimits)
{
    if(myIsVisible==false)
        return;
    //
    if(myCenterX==_xcnew && myCenterY==_ycnew)
        return;
    //
    this->setInvisible(true); // colorie le cir avec couleur de la screen

    myIsVisible=true;
    if(isScreenLimits) {
        //test Xmax
        if(_xcnew+myRadiusX >= myXMoveMax) {
            _xcnew=myXMoveMax-myRadiusX;

            if(myState==STATE_ON)
                myState=BUMP_RIGHT;
        }

        //test Xmin
        if(_xcnew <= myRadiusX) {
            _xcnew=myXMoveMin+myRadiusX;

            if(myState==STATE_ON)
                myState=BUMP_LEFT;
        }
        //test Ymax
        if(_ycnew +myRadiusY >= myYMoveMax && _ycnew >0) {
            _ycnew = myYMoveMax- myRadiusY;

            if(myState==STATE_ON)
                myState=BUMP_DOWN;
        }
        //test yminMin;
        if(_ycnew <= myRadiusY) {
            _ycnew=myYMoveMin+myRadiusY;

            if(myState==STATE_ON)
                myState=BUMP_UP;
        }
    }
    //
    myCenterX=_xcnew;
    myCenterY=_ycnew;

    myX=_xcnew-myRadiusX;
    myY=_ycnew-myRadiusY;


    this->draw();
}
//-----------------------------------------------
Ellipse::~Ellipse(void)
{
}
//----------------------------------------------
UINT16 Ellipse::getCenterX(void) const
{
    return this->myCenterX;
}
//---------------------------------------------
UINT16 Ellipse::getCenterY(void) const
{
    return this->myCenterY;
}
//----------------------------------------------
void Ellipse::setCenterX(UINT16 _xcenter)
{
    myCenterX=_xcenter;
}
//----------------------------------------------
void Ellipse::setCenterY(UINT16 _ycenter)
{
    myCenterY=_ycenter;
}