#ifndef DIGIT_3_LED_H
#define DIGIT_3_LED_H

#include "Screen.h"
#include "DigitLed.h"

class Digit3Led:public Widget
{
public:
    /** Construct a 3 Digit Led [000]
        *
        * @param mScreen the pointer screen
        * @params _x up left
        * @params _y up left
        * @params _resolution 1[000],10[00.0],100[0.00]
        */
    Digit3Led(Screen* mScreen,UINT16 _x,UINT16 _y,UINT8 _resolution);
    //
    virtual void draw(void);
    //
    virtual  ~Digit3Led(void);
    //
    void setInvisible(bool _state);
    //
    void setValue(float _value);
    //
    void setColorBkg(Color _colorBkg);
    //
    void setColorSeg(Color _colorSeg);

protected:
    Color myColorBkg;
    Color myColorSeg;
    float myValue;
    UINT8 myResolution;

    DigitLed* myDigitLedCentaine;
    DigitLed* myDigitLedDizaine;
    DigitLed* myDigitLedUnite;

};

#endif