#ifndef DIAMOND_H
#define DIAMOND_H

#include "Screen.h"
#include "Sprite.h"


class Diamond:public Sprite
{
public:
    /** Construct a filled Diamond
    *
    * @param mScreen the pointer screen
    * @params x1
    * @params y1
    * @params x2
    * @params y2
    * @params x3
    * @params y3
    * @params x4
    * @params y4
    * @param _color the background color
    */
    Diamond(Screen* mScreen,UINT16 x1,UINT16 y1,UINT16 x2,UINT16 y2,
            UINT16 x3,UINT16 y3,UINT16 x4,UINT16 y4,Color _color);
    //
    virtual void draw(void);
    //
    virtual ~Diamond(void);
    //
    void update(float delta);

//setter
    void setInvisible(bool _state);
    //
    void setNewPosition(INT16 _xnew,INT16 _ynew);
    //
    void setNewPosition(INT16 _xnew,INT16 _ynew,bool isScreenLimits);

protected:
    UINT16 myX1,myY1;
    UINT16 myX2,myY2;
    UINT16 myX3,myY3;
    UINT16 myX4,myY4;
    UINT16 myU1,myU2;
    UINT16 myV1,myV2;

};

#endif