#ifndef BUTTON_H
#define BUTTON_H

#include "Screen.h"

class Button:public Widget
{
public:
    /** Construct a Button
    *
    * @param mScreen the pointer screen
    * @param _id the identifier Id
    * @params _x up left
    * @params _y up left
    * @params _text
    * @params _font
    * @params _colorText
    * @params _colorBtn
    * @params _state BUTTON_STATE_PRESSED or BUTTON_STATE_RELEASED,
    */
    Button(Screen* mScreen,UINT16 _id,UINT16 _x,UINT16 _y,string _text,Font _font,
           Color _colorText,Color _colorBtn,State _state);
    //
    virtual void draw(void);
    //
    virtual ~Button(void);

    //setter
    void setInvisible(bool _state);
    //
    void setState(State _state);

protected:
    string myText;
    Font myFont;
    Color myColorText;
};

#endif