/**************************************************************************
 *  Name:        Stoppuhr
 *  Date  :
 *  Author:
 *  Revision List:
  --------------------------------------------------------------------------
  Date     | Author          | Change
  --------------------------------------------------------------------------
           |                 |
  --------------------------------------------------------------------------
 **************************************************************************/
#include "mbed.h"
#include "cdef.h"
#include "TextLCD.h"


TextLCD     stLcd(p26, p25, p24, p23, p22, p20, p19, TextLCD::LCD20x4); // rs, e, d4-d7

DigitalOut  abLed[] = {         /* Ausgabe-LEDs */
    (LED1), (LED2),(LED3), (LED4)
};

DigitalIn   bBtn1(p8);
DigitalIn	bBtn2(p14);

int8 i=5;

int16 bTastTimerLi=0;

#define nTastLongLi 100
#define nTastShortLi 5

char acZ1t[]="Zeit 1 [sec.]  ---.-";
char acZ2t[]="Zeit 2 [sec.]  ---.-";
char acZ3t[]="Zeit 3 [sec.]  ---.-";
char acZ4t[]="Final  [sec.]  ---.-";

char acZ1h[]="Dusche1Dusche Dusche";
char acZ2h[]="Dusche2Dusche Dusche";
char acZ3h[]="Dusche3Dusche Dusche";
char acZ4h[]="Dusche4Dusche Dusche";

char acDisp[4][20];

int8 count=0;

volatile char bStandby = 0;

Ticker stSysTick;

void vTimer( void ){
abLed[1] = 1;
bStandby = 1;
} 


/* Funktion "Taste 1 gedrückt" */
void vBtn1Short( void )
{

}

/* Funktion "Taste 1 lange gedrückt" */
void vBtn1Long( void )
{

}

/* Funktion "Taste 1 losgelassen" */
void vBtn1Free( void )
{

}

void vDispReset(void)
{
    for(int y=0; y<sizeof(acZ1t); y++) {
        acDisp[0][y]=acZ1t[y];
        acDisp[1][y]=acZ2t[y];
        acDisp[2][y]=acZ3t[y];
        acDisp[3][y]=acZ4t[y];
    }
}


/*******************************************
 * APP1 - Taste 1 abfragen
 *******************************************/
void vTaste1( void )
{
    if(bBtn1 == 0) {
        if(bTastTimerLi < (nTastLongLi+1)) {
            if(bTastTimerLi == nTastShortLi) {
                vBtn1Short();
            }
            if(bTastTimerLi == nTastLongLi) {
                vBtn1Long();
            }
            bTastTimerLi++;
        }
    } else {
        if(bTastTimerLi >= nTastLongLi) {
            vBtn1Free();
        }
        bTastTimerLi = 0;
    }
}

/*******************************************
 * APP2 - Taste 2 abfragen
 *******************************************/
void vTaste2( void )
{

    if(count==nTastLongLi) {
        abLed[0]=!abLed[0];
        count=0;
    } else {
        count++;
    }


}


/*******************************************
 * APP3 - LCD-Ausgabe
 *******************************************/
void vLcdOut( void )
{
    for(int x=0; x<sizeof(acDisp); x++) {
        for(int y=0; y<sizeof(acDisp[x]); y++) {
            stLcd.locate(y,x);
            stLcd.putc(acDisp[x][y]);
        }
    }
}


/* Hauptprogramm */
int main()
{
   stSysTick.attach(&vTimer, 0.02);
    bStandby=0;
    vDispReset();
    

    while(1) {
        
        // wait until bStandby !=0
       while(bStandby == 0){
        abLed[0] = 1;
        }
        bStandby = 0;
        abLed[2] = 1;
        // vTaste1();
        // vTaste2();
        i--;
        if(i == 0) {
            i = 5;

           // vLcdOut();

        }
    }
}

