#include "mbed.h"

#define anz 6

DigitalIn b1(p8);
DigitalIn b2(p14);
DigitalOut led[] = {(LED1), (LED2),(LED3),(LED4)};


bool shortPress =false;
bool longPress = false;
bool isRight=true;

int counterTime = 0;
int counterBlink=anz;

Ticker timeTasterTest;
Ticker timeLedTest;

void tasterTest();
void ledTest();
void reset();

int main()
{
    timeTasterTest.attach(&tasterTest,0.01);
    timeLedTest.attach(&ledTest,0.5);

    while(1) {


    }
}

void ledTest()
{
    if(shortPress) {
        if(counterBlink>=0) {
            if(!isRight) {
                led[3]=!led[3];
            } else {
                led[0]=!led[0];
            }
            counterBlink--;
        } else {
            reset();
        }
    }
    if(longPress) {
        if(!isRight) {
            led[3]=!led[3];
        } else {
            led[0]=!led[0];
        }
    }



}

void tasterTest()
{
    if(!b1 != !b2) {
        if(!b1&&isRight) {
            isRight=false;
            reset();
        }

        if (!b2&&!isRight) {
            isRight=true;
            reset();
        }

        if(counterTime<500) {
            longPress=false;
            shortPress=true;
            counterTime ++;
        } else {
            counterTime=0;
            longPress=true;
            shortPress=false;
        }
    } else {
        if(longPress) {
            reset();
        }
    }
}

void reset()
{
    counterTime=0;
    longPress=false;
    shortPress=false;

    led[3]=0;
    led[0]=0;
    counterBlink=anz;
}



