#include "mbed.h"
#include <cmath>
#define a_depan 5000000
#define b_depan 1.229
Serial pc(USBTX,USBRX, 115200);

float call_depan(uint16_t x)
{
    float side_distance = a_depan/pow(x,b_depan)+1;
    return side_distance;
}

// atas
AnalogIn ira1(PC_5);
AnalogIn ira2(PA_5); // tidak membaca, semua yg di board udh ok, kabel sama irnya juga oke
AnalogIn ira3(PC_2);
AnalogIn ira4(PC_3);
AnalogIn ira5(PC_4);
AnalogIn ira6(PB_1);
AnalogIn ira7(PA_7);
AnalogIn ira8(PA_6);
// bawah
AnalogIn irb1(PA_0); // tidak membaca, kayanya header di board bawah agak longgar
AnalogIn irb2(PA_1); // tidak membaca
AnalogIn irb3(PA_4);
AnalogIn irb4(PB_0);
 
DigitalOut led(LED1);

int main() {
    
    while(1) {
        uint16_t raw_a1 = ira1.read_u16();
        uint16_t raw_a2 = ira2.read_u16();
        uint16_t raw_a3 = ira3.read_u16();
        uint16_t raw_a4 = ira4.read_u16();
        uint16_t raw_a5 = ira5.read_u16();
        uint16_t raw_a6 = ira6.read_u16();
        uint16_t raw_a7 = ira7.read_u16();
        uint16_t raw_a8 = ira8.read_u16();
        uint16_t raw_b1 = irb1.read_u16();
        uint16_t raw_b2 = irb2.read_u16();
        uint16_t raw_b3 = irb3.read_u16();
        uint16_t raw_b4 = irb4.read_u16();
        
        float dist_a1 = call_depan(raw_a1);
        float dist_a2 = call_depan(raw_a2);
        float dist_a3 = call_depan(raw_a3);
        float dist_a4 = call_depan(raw_a4);
        float dist_a5 = call_depan(raw_a5);
        float dist_a6 = call_depan(raw_a6);
        float dist_a7 = call_depan(raw_a7);
        float dist_a8 = call_depan(raw_a8);
        float dist_b1 = call_depan(raw_b1);
        float dist_b2 = call_depan(raw_b2);
        float dist_b3 = call_depan(raw_b3);
        float dist_b4 = call_depan(raw_b4);
        pc.printf("ir atas\n");
        
        pc.printf("%.2f   %.2f %.2f   %.2f\n", dist_b2, dist_a3, dist_a1, dist_b1); 
        pc.printf("%.2f               %.2f\n", dist_a2, dist_a5); 
        pc.printf("%.2f               %.2f\n", dist_a4, dist_a6);
        pc.printf("%.2f   %.2f %.2f   %.2f\n", dist_b4, dist_a8, dist_a7, dist_b3);
 
//        pc.printf("ir bawah\n");
//        pc.printf("      %.2f\n", dist_b1);
//        pc.printf("%.2f            %.2f\n", dist_b2, dist_b3);
//        pc.printf("      %.2f\n", dist_b4);
//        x1 = (330377) * (pow(M1 , (-1.349f)));
        //printf("volt %f\n", meas);
//        if (meas > 2000000) { // If the value is greater than 2V then switch the LED on
//          led = 1;
//        }
//        else {
//          led = 0;
//        }
        wait(0.2); 
        pc.printf("\033[2J\033[H");
    }
}
