#include "mbed.h"
#include "Adafruit_ADS1015.h"

#define SERIAL_BAUD_RATE    9600

#define a_samping       500000
#define b_samping       1.184
//#define b_samping       1.229
#define a_depan         10000000
#define b_depan         1.297

I2C i2c(D14, D15);
Adafruit_ADS1015 ads(&i2c);
Serial pc(USBTX, USBRX);

float dist = 0;

float call_samping(uint16_t x) {
  float side_distance = a_samping/pow(x,b_samping)+1;
    return side_distance;
}

float call_depan(uint16_t x){
    float front_distance = a_depan/pow(x,b_depan);
    return front_distance;
}

int main() {
    uint16_t ir;
    const uint16_t u16tmax = 0xFFFF;
    while (1) {
        ir = ads.readADC_SingleEnded(2);
        float voltage = ir * 6.2676 * 10e-5;
        uint16_t x = voltage/3.3 * 0xFFFF ;
        float dist = call_samping(x);
//        pc.printf("raw = %ul volt = %.2f x=%ul dist=%.2f \n", ir, voltage, x, dist);
        pc.printf("%.5f     %.5f\n", voltage,dist);
        wait(0.08); // loop 2 sek
    }
}