#include "mbed.h"
Serial pc(USBTX, USBRX);
// A class for flip()-ing a DigitalOut 
class Flipper {
    int     ii;
public:
    Flipper(PinName pin) : _pin(pin) {
        _pin = 0;
        ii = 0;
    }
    void flip() {
        ii++;
        if( ii > 4000 ) {
            _pin = !_pin;
            ii=0;
        }     
    }
private:

    DigitalOut _pin;
};

DigitalOut led(LED1);
DigitalOut led2(LED2);
Flipper f(LED3);
Ticker t;
 
int main() {
    t.attach_us(&f, &Flipper::flip, 25 ); // the address of the object, member function, and interval
                                            // 25 us = 40kHz
    //led3 = 1;
 
    // spin in a main loop. flipper will interrupt it to call flip
    while(1) {
        led = !led;
        wait(0.5);
    }
}