#include "mbed.h"

Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut led01(LED1);

// 光流传感器接口,串口,波特率115200,每一帧数据20个byte
// IO口定义
Serial Optical_Flow(PA_15,PB_7);
// 变量
char *get_Optical_Flow_Cmd();
// 数据处理函数
void Optical_Flow_Process_Cmd(char *cmd);
// 线程实现函数
void Optical_Flow_Call_Back();
// 线程
Thread Optical_Flow_Thread;




int i;          // for cycles
char cmd_on[] = "on";
char cmd_off[] = "off"; 
    
char *getCmd();
void processCmd(char *cmd);

Thread t1;

 ///////////////////////////////////////////////////////////////////////////////
void tSerial_body()
{
    while(1){ 
        if (pc.readable())     // if there is an character to read from the device
        {
            char *SerialCommand = getCmd();
            processCmd(SerialCommand);
            free(SerialCommand);
        }   
    }    
}
////////////////////////////////////////////////////////////////////////////////
void Optical_Flow_Call_Back()
{
    while(true)
    {
        if (Optical_Flow.readable()) // if there is an character to read from the device
        {
            char *SerialCommand = get_Optical_Flow_Cmd();
            Optical_Flow_Process_Cmd(SerialCommand);
            free(SerialCommand);
        }
    }
}
 ///////////////////////////////////////////////////////////////////////////////
char *getCmd()
{
    char buff[128];
    unsigned char ch;
    int buffIndex = 0;
    memset(buff, 0, sizeof(buff));          // clean the buffer


    char *cmd = (char*)malloc(128);
    if (!cmd)
        return NULL;
    do 
    {
        ch = pc.getc();   // read it
        if (buffIndex < 128){               // just to avoid buffer overflow
            buff[buffIndex] = ch;  // put it into the value array and increment the index
            buffIndex++;
        }
     }
     while (ch != '\n' && ch != '\r' );
     buff[buffIndex]='\0';  // add the end-signalling char
             
    if(strlen(buff) != 0){
        
        for (i = 0 ; i < sizeof(buff) ; i++){
            if (buff[i] == '\n' || buff[i] == '\r'){
                cmd[i] = '\0';
                return cmd;
            }
            cmd[i] = buff[i];                
        }
    }  
    return NULL;  
}

char *get_Optical_Flow_Cmd()
{
    char buff[128];
    unsigned char ch;
    int buffIndex = 0;
    memset(buff, 0, sizeof(buff));          // clean the buffer
    
    char *cmd = (char*)malloc(128);
    if (!cmd)
        return NULL;
    do 
    {
        ch = Optical_Flow.getc();           // read it
        if (buffIndex < 128){               // just to avoid buffer overflow
            buff[buffIndex] = ch;           // put it into the value array and increment the index
            buffIndex++;
        }
     }
     while (ch != '\r' && ch != '\n' );
     buff[buffIndex]='\0';                  // add the end-signalling char
    
    if(strlen(buff) != 0){
        
        for (i = 0 ; i < sizeof(buff) ; i++){
            if (buff[i] == '\r' || buff[i] == '\n'){
                cmd[i] = '\0';
                return cmd;
            }
            cmd[i] = buff[i];                
        }
    }  
    return NULL;
}
 ///////////////////////////////////////////////////////////////////////////////
void processCmd(char *cmd)
{
    pc.printf("rec: \"%s\"\n\r", cmd);
    if(strcmp(cmd,cmd_on) == 0){
        led01 = 1;
        pc.printf("Turning the led on.\n\r");
    } else if (strcmp(cmd,cmd_off) == 0) {
        led01 = 0;    
        pc.printf("Turning the led off.\n\r");
    
    }
}

void Optical_Flow_Process_Cmd(char *cmd)
{
    int8_t Delta_X,Delta_Y,Delta_Z;
    
    Delta_X = (int8_t)(cmd[6]);
    Delta_Y = (int8_t)(cmd[7]);
    Delta_Z = (int8_t)(cmd[5]);
    //pc.printf("rec: \"%s\"\n\r", cmd);
    pc.printf("\r\n X:%d, Y:%d, Z:%d",Delta_X,Delta_Y,cmd[5]);
}
///////////////////////////////////////////////////////////////////////////////
int main() 
{
    pc.baud(115200);
    Optical_Flow.baud(115200);
    //t1.start(tSerial_body);
    Optical_Flow_Thread.start(Optical_Flow_Call_Back);
    pc.printf("\r\n Optical Flow Test \r\n");
    //led01 = 1;
    
    //pc.printf("\n\r App started______Banik pyco\n\r");
    //int counter = 1;
    while(1)
    {   
        //pc.printf("seconds: %d\n\r", counter++);
        wait(1);
    }
}