#include "mbed.h"
#include "rtos.h"

#include "LED.h"        //LED控制的头文件
#include "ReceiverIR.h" //红外接收的头文件
#include "HCSR04.h"     //超声波模块的头文件
#include "motodriver.h"
#include "encoder.h"

// 变量
int     ir_bitcount, ir_decoded;

// IO口定义声明
LED           user_led(PA_5);
Serial        pc(PA_2,PA_3);
ReceiverIR    ir_rx(PB_12);        // 声明一个红外接接口,这里用PB12,这里可以使用一个通用的IO口就可以,不需要专门的IO口
HCSR04        sr04(PC_0, PC_1);    // 声明两个IO口连接SR04模块,PC_0->ECHO PC1->TRIG
Motor         motor1(PA_8,PA_9);   // 声明两个IO口连接电机1驱动模块,必须具有PWM功能的IO
Motor         motor2(PA_11,PA_10); // 声明两个IO口连接电机2驱动模块,必须具有PWM功能的IO
Encoder       encoder1(PB_14,PB_13,true);

// Thread 线程
Thread thread_led;
Thread thread_ir;
Thread thread_sr04;

// Timer
Timer sr04_timer;

// 线程实现函数
void led_thread();
void ir_thread();
void sr04_thread();

// main() runs in its own thread in the OS
int main() 
{
    // 初始化
    user_led.LED_Off();
    
    pc.baud(115200);
    pc.printf("\r\n*** Nucleo_F411RE_OS_Robot ***");
    pc.printf("\r\n***      Hello World!      ***");
    
    // 延时一下
    wait(1.0);
    
    // 启动线程
    thread_led.start(led_thread);
    thread_ir.start(ir_thread);
    thread_sr04.start(sr04_thread);
    
    while (true) 
    {
        //pc.printf("pos: %d, speed %f \r\n",encoder1.getPosition(), encoder1.getSpeed());
        switch(ir_decoded)
        {
            case 0xb9://forward
                motor1.Speed(0.5);
                motor2.Speed(0.5);
                break;
            case 0xbf://stop
                motor1.Stop();
                motor2.Stop();
                break;
            case 0xea://backward
                motor1.Speed(-0.5);
                motor2.Speed(-0.5);
                break;
            case 0xbb://turn_left
                motor1.Speed(-0.5);
                motor2.Speed(0.5);
                break;
            case 0xbc://turn_right
                motor1.Speed(0.5);
                motor2.Speed(-0.5);
                break;
            default:
            break;
        }
        Thread::wait(1);
    }
}

/*************************************************/
// LED线程 1秒钟闪烁一次
void led_thread() 
{
    while(true)
    {
        Thread::wait(1000);
        user_led.LED_Troggle();
    }
}

// 红外接收线程
void ir_thread()
{
    // 和红外接收有关的变量
    RemoteIR::Format format;
    uint8_t buf[32];
    
    while(true)
    {
        if (ir_rx.getState() == ReceiverIR::Received) 
        {
            ir_bitcount = ir_rx.getData(&format, buf, sizeof(buf) * 8);
            if (ir_bitcount>0) 
            {
                ir_decoded=buf[3];
                pc.printf("\r\n ir_receive_code: %x",ir_decoded);
            }
            pc.printf(".");
        } 
    }
}

// SR04超声波测距模块线程
void sr04_thread()
{
    while(true)
    {
        sr04_timer.reset();
        sr04_timer.start();
        sr04.startMeasurement();
        while(!sr04.isNewDataReady()) {
          // wait for new data
          // waiting time depends on the distance
        }
        //pc.printf("\r\n Distance: %5.1f mm", sr04.getDistance_mm());
        sr04_timer.stop();
        Thread::wait(500 - sr04_timer.read_ms()); // time the loop
    }
}