#include "mbed.h"
#include "motodriver.h"

Motor::Motor(PinName pwm1pin, PinName pwm2pin) : _pwm1(pwm1pin) , _pwm2(pwm2pin)
{
    init();    
}

void Motor::init()
{
    // Set initial condition of PWM
    _pwm1.period(0.001);  //初始化PWM的周期,参数的单位是s,0.001s=1ms,所以PWM周期是1KHz
    _pwm1 = 0;
    
    // Set initial condition of PWM
    _pwm2.period(0.001);  //初始化PWM的周期,参数的单位是s,0.001s=1ms,所以PWM周期是1KHz
    _pwm2 = 0;
}

float Motor::Speed(float speed)
{
    float temp;
    temp = abs(speed);
    
    if (speed > 0.0)
    {
        _pwm1 = temp;
        _pwm2 = 0;
    }
    else
    {
        _pwm1 = 0;
        _pwm2 = temp;
    }
    
    return temp;
}

void Motor::Stop()
{
    _pwm1 = 0;
    _pwm2 = 0;
}