#ifndef LED_H_ADA
#define LED_H_ADA

/*
Example of use:
* @code
*LED user_led(LED1);
*int main() 
*{
*    
*    while (true) 
*    {
*        user_led.LED_On();
*        wait(0.05);
*        user_led.LED_Off();
*        wait(0.05);
*    }
*}
* @code
*/

class LED 
{
    public:
    LED(PinName ledpin);
    
    // LED亮起控制函数,IO口输出高电平
    void LED_On();
    
    // LED关闭控制函数,IO口输出低电平
    void LED_Off();
    
    // LED闪烁控制函数,每次调用该函数,则IO口翻转一次状态
    void LED_Troggle();
    
    private:
    DigitalOut led;
    
    // 初始化函数
    void init();
};

#endif