// NOTES:
// 1. mbed.h MUST BE the revision from 30 Mar 2016, otherwise it will behave strange and unexpected! Older or newer versions won't work.
//    For example, with the latest version of mbed.h from 25 May 2016, the "wait" function does not work at all, it's the same as if it's not there.
// 2. writeEEPROM has 64 bytes limitation. If you want to write more at once, read http://www.hobbytronics.co.uk/eeprom-page-write how this guy made it work.
//    Im not interested in storing data above 64 bytes (1 page). The 24LC256 chip has 4096 pages.
// 3. reading the entire eeprom does its job until the 512 byte, then it will cycle from zero. I don't know why...
#include "mbed.h"

// function declaration
void writeEEPROM(int address, unsigned int eeaddress, char *data, int size);
void readEEPROM(int address, unsigned int eeaddress, char *data, int size);

// classes and functions instantiation
I2C i2c(I2C_SDA, I2C_SCL);
Serial pc(SERIAL_TX, SERIAL_RX);

// settings
int address = 0xA8; // in my case A2 = high, A1 = low, A0 = low, so the address is 1010 1000 = A8 (format 1 0 1 0 A3 A2 A1 R/W)

int main()
{
    pc.printf("24LC256 I2C EEPROM started...\n");

    int pointerAdddress = 0;

    // write some data on eeprom
    char writeData[] = {"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec f"}; // the text length must be below 64 bytes
    char writeDataLen = 0;
    do {writeDataLen++;} while (writeData[writeDataLen]); // calculate the text length
    /*
    writeEEPROM(address, pointerAdddress, writeData, writeDataLen);

    pc.printf("Data written: %s\n", writeData);
    */

    // read the data back
    char data_read[writeDataLen];
    readEEPROM(address, pointerAdddress, data_read, writeDataLen);

    pc.printf("Data read: %s\n", data_read);

    // read the entire eeprom
    /*
    pc.printf("Printing the entire EEPROM array (64 columns, 4096 rows):\n");
    int i;
    char data_chunk[64];
    int pointer;
    for (i = 0; i < 4096; i++)
    {
        pointer = 64 * i;
        readEEPROM(address, pointer, data_chunk, 64);
        pc.printf("row: %4d, data: %s\n", i, data_chunk);
    }
    */

    // delete the entire eeprom
    /*
    pc.printf("Deleting the entire EEPROM array (64 columns, 4096 rows):\n");
    int i;
    int pointer;
    char deleteData[] = {"0000000000000000000000000000000000000000000000000000000000000000"}; // 64 bytes data length of zeros
    for (i = 0; i < 4096; i++)
    {
        pointer = 64 * i;
        writeEEPROM(address, pointer, deleteData, 64);
    }
    pc.printf("Erasing complete\n");
    */
}

// this function has 63 bytes write limit
void writeEEPROM(int address, unsigned int eeaddress, char *data, int size)
{
    char i2cBuffer[size + 2];
    i2cBuffer[0] = (unsigned char)(eeaddress >> 8); // MSB
    i2cBuffer[1] = (unsigned char)(eeaddress & 0xFF); // LSB

    for (int i = 0; i < size; i++) {
        i2cBuffer[i + 2] = data[i];
    }

    int result = i2c.write(address, i2cBuffer, size + 2, false);
    wait_ms(6);
}

// this function has no read limit
void readEEPROM(int address, unsigned int eeaddress, char *data, int size)
{
    char i2cBuffer[2];
    i2cBuffer[0] = (unsigned char)(eeaddress >> 8); // MSB
    i2cBuffer[1] = (unsigned char)(eeaddress & 0xFF); // LSB

    // Reset eeprom pointer address
    int result = i2c.write(address, i2cBuffer, 2, false);
    wait_ms(6);

    // Read eeprom
    i2c.read(address, data, size);
    wait_ms(6);
}