#include "convert_lmt70.h"

/*  Converts voltage output from Texas Instruments LMT70 temp sensor into degrees C
  using the 3rd-order lookup table that's a best fit for the full range of -55C - 150C
  found at http://www.ti.com/lit/ds/symlink/lmt70.pdf
*/
float convert_lmt70 (float mV) {
    float a, b, c, d;
    a = -1.064200E-09;
    b = -5.759725E-06;
    c = -1.789883E-01;
    d = 2.048570E+02;

    return a*mV*mV*mV + b* mV*mV + c*mV + d;
}