#include "mbed.h"
#include "solenoid.h"
Solenoid::Solenoid(PinName pin, float ondelay, float offdelay) : _pin(pin), ontime(ondelay), offtime(offdelay)
{
    _pin=0;
    offtimer.start();
 
}
void Solenoid::Solenoid_Off_Int()
{
    _pin=0;//OFF timer interrupt routine to auto turn off solenoid
    offtimer.start(); //start off-time delay count
}
void Solenoid::write(bool value)
{
    if (value!=0) {//ON so do auto off with timer interrupt
        while(offtimer.read() < offtime); //wait for min OFF time before next ON allowed
        offtimer.stop();
        offtimer.reset(); //reset off timer delay count
        tint.attach(this,&Solenoid::Solenoid_Off_Int,ontime);//setup a timer interrupt for on time
    } else
        offtimer.start(); //solenoid turned off with a write call (not timers) so start off count
    _pin = value;
}
Solenoid& Solenoid::operator= (bool value)
{
    write(value);
    return *this;
}
 
