#include "mbed.h"
#include <cmath>
#include "solenoid.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "TMP36.h"
#include "motordriver.h"
#include "PinDetect.h"
#include "mpr121.h"      //touchpad
#include "DebounceIn.h"
#include  "Speaker.h"    //used for playing tones
Speaker mySpeaker(p18); 
Serial blue(p13,p14); //blue tooth device
TMP36 myTMP36(p15);  //Analog in
Mutex mut; //standard io mutex lock
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
AnalogIn ir(p19); //Sharp IR sensor 
uLCD_4DGL uLCD(p28,p27,p30); //create a global lcd object
I2C i2c(p9, p10);
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);
InterruptIn interrupt(p25);
PinDetect pb1(p21);//push button 1
PinDetect pb2(p22);//push button 2
PinDetect pb3(p23);//push button 3
PinDetect pb4(p24);//push button 4
Motor  left(p26, p16, p17, 1); // pwm, fwd, rev, has brake feature
Solenoid mySolenoid(p8); 
  char bnum=0;
    char bhit=0;
float tempC = 0.0;
bool shadeDown = true; //true shade is down, false shade is up
bool tempMode = false; //false is celcius, true is fahrenheit
int combo[5];
bool setUp = false; //boolean for initial setup of safe (will be set to true after passcode is entered)
bool locked = true; //boolean if safe is locked or not.
int passCode[5];
int j = 0;
int passVal = 0; //keeps track of correct input values
bool passed = true; //this boolean will be used to unlock the safe
bool pb1push = false; //pushbutton 1 was pushed boolean
bool pb2push = false;
bool pb3push = false;
bool pb4push = false;
int failVal = 0; //counts failed attempts
int key_code = -17; //set this to a negative number that won't ever be in Simon's array and also isn't a possible value for drawing
void fallInterrupt() {
  int i=0;
  int value=mpr121.read(0x00);
  value +=mpr121.read(0x01)<<8;
  // LED demo mod
  i=0;
  // puts key number out to LEDs for demo
  for (i=0; i<12; i++) {
  if (((value>>i)&0x01)==1) key_code=i;
  }

}
void unlocker() {
     mySolenoid =1;
    
      wait(2);
      mySolenoid = 0;
}
void lockInterrupt() {
    //button 1
   pb1push = true;
        led1 = 1;
        wait(0.5);
        led1 = 0;
    mySpeaker.PlayNote(400, 0.5, 1.0);
}
void shadeInterrupt() {
   //button 2 
    pb2push = true;
    led2 = 1;
    wait(0.5);
    led2 = 0;
    mySpeaker.PlayNote(800, 0.5, 1.0);
}
void settingsInterrupt() {
    //button 3
    //will be able to change passcode.
    //change temp display
    //change display shade.
    pb3push = true;
    led3 = 1;
        wait(0.5);
        led3 = 0;
    mySpeaker.PlayNote(1200, 0.5, 1.0);
}    

void exitInterrupt() {
    //button 4
    pb4push = true;
    led4 = 1;
        wait(0.5);
        led4 = 0;
    mySpeaker.PlayNote(1600, 0.5, 1.0);
}
void setPassword() {
    uLCD.cls();
    uLCD.color(WHITE);
    uLCD.printf("Please put in your \n 5 digit passcode now \n \n \n \n");
    wait(0.5);
    int i = 0;
    while(i < 5 && !pb4push) {
        if (key_code >= 0) {
            combo[i] = key_code;
            uLCD.text_height(4);
            uLCD.text_width(2);
            uLCD.printf("%d ",combo[i]);
            i++;
            key_code = -4;
        }
    }
    wait(0.5);
    uLCD.cls();
    uLCD.printf("Passcode saved. \nLock engaged. \n");
    wait(1);
    uLCD.cls(); 
}
void shadeMove() {
    uLCD.cls();
    if(shadeDown) {
    
    shadeDown = false;
    //turn motor backward.
    for (int i = 0; i < 6 ; i ++) {
        led1=!led1;
        left.speed(.5);
        wait(0.2);
    }
    left.speed(0);
    uLCD.printf("Removing shade.");    
    wait(2); //might need to be longer dependent on actual mplementation speed
    uLCD.cls();
    } else {
    shadeDown = true;
    for (int i = 0; i < 6 ; i ++) {
        led1=!led1;
        left.speed(-.5);
        wait(0.2);
    }
    left.speed(0);
    //turn motor forward    
    uLCD.printf("Placing shade.");
    wait(2); //might need to be longer dependent on actual mplementation speed
    uLCD.cls();
    }    
}
void bluetoothOn() {
 while (!pb4push) {
    if (blue.getc()=='!') {
            uLCD.locate(0,0);
            uLCD.printf("In Bluetooth Mode.");
            if (blue.getc()=='B') { //button data packet
                bnum = blue.getc(); //button number
                bhit = blue.getc(); //1=hit, 0=release
                if (blue.getc()==char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                   // myled = bnum - '0'; //current button number will appear on LEDs
                    switch (bnum) {
                        case '1': //number button 1
                           if (bhit=='1') {
                                unlocker();
                              //add hit code here
                                //open safe (or close safe) dependent on state
                            } else {
                                //add release code here
                            }
                            break;
                        case '2': //number button 2
                            if (bhit=='1') {
                                //add hit code here
                                //move shade
                                 shadeMove();
                            } else {
                               
                                //add release code here
                            }
                            break;
                        case '3': //number button 3
                            if (bhit=='1') {
                                tempMode = !tempMode;
                            } else {
                                //add release code here
                            }
                            break;
                        case '4': //number button 4
                            if (bhit=='1') {
                                //add hit code here
                                pb4push = true;
                            } else {
                                //add release code here
                            }
                            break;
                      
                    }
                }
            }    
    }
    }
}
int main() {
    set_time(46800); // Set RTC time to Wed, 28 Oct 2009 11:35:37 let's change this to wahtever the presentation day is.
//clock stuff goes here

pb1.mode(PullUp); //the safe unlock/lock method initiator
pb2.mode(PullUp); //the shade button
pb3.mode(PullUp); //temperature button
pb4.mode(PullUp); //exit routine button
wait(.01);
// Setup Interrupt callback functions for a pb hit
pb1.attach_deasserted(&lockInterrupt);
pb2.attach_deasserted(&shadeInterrupt);
pb3.attach_deasserted(&settingsInterrupt);
pb4.attach_deasserted(&exitInterrupt);
pb1.setSampleFrequency();
pb2.setSampleFrequency();
pb3.setSampleFrequency();
pb4.setSampleFrequency();
interrupt.fall(&fallInterrupt); //setting up the touch pad for use by assigning a method for the falling side of the touchpad interrupt
interrupt.mode(PullUp);         //put the interrupt mode to pull up, so that interrupts will trigger when the touchpad is hit
    while(1) {
        time_t seconds = time(NULL);
        //if ir.read is greater than .5 beep(?)
        tempC = myTMP36.read();
        if (!setUp) {
            mut.lock();
            uLCD.color(WHITE);
            uLCD.printf("Welcome to \nSMART Safe.");
            
            wait(1.0);
            uLCD.cls();
            setPassword();
            mut.unlock();
            setUp = true;
            //put in clock
            //put in temp
        } else if (pb1push) {
                 pb1push = false;
                 pb4push = false;
                 uLCD.cls();
                 uLCD.printf("Enter your pass code now.\n");
                 while (passVal < 5 && failVal < 5 && !pb4push) {
                    if(key_code >= 0) {
                        uLCD.text_height(4);
                        uLCD.printf("%d ",key_code);
                        if (key_code == combo[j]) {
                            passVal++;
                            passed = true;
                        } else {
                            passed = false;
                            j = 0;
                            failVal++;
                        } 
                        key_code = -1;
                    }   
                    if (passVal == 5 && passed && failVal < 5) {
                        passed = true;
                        pb1push = false;
                        j = 0;
                        failVal = 0;   
                        uLCD.cls();
                        uLCD.printf("Safe unlocked.");
                        locked = false;
                        unlocker();
                        locked = true;
                        break;
                    }
                    if (failVal == 5) {
                        uLCD.printf("You have put in \n the wrong password \n five times. \n You are locked out.");    
                    }  
                }    
                if(pb4push){
                    pb4push = false;
                    uLCD.printf("Unlocking \nsequence \naborted.");  
                }  
                passVal = 0;
                failVal = 0;
                wait(1);
                uLCD.cls();
            } else if (pb2push) { 
            pb2push = false;

                shadeMove();
            
        } else if(pb3push){
            pb3push = false;
            uLCD.cls();
            while (!pb4push) {
                uLCD.locate(0,0);
                uLCD.printf("Change Temperature Format (1)\n");
                uLCD.printf("Change Passcode (2) \n");
                uLCD.printf("Enter BLUETOOTH \n mode (3)\n");
                uLCD.printf("Exit menu (4)");
                wait(1);
                if (pb1push) {
                    pb1push = false;
                    uLCD.cls();
                    uLCD.printf("Fahrenheit (1)\n");
                    uLCD.printf("Celcius (2)");
                    wait(1); 
                    bool action = false;
                    while (!pb4push && !action) {  
                        if (pb1push) {
                            action = true;
                            pb1push = false;
                            tempMode = true;//thermometer change to F   
                            break; 
                        } else if (pb2push) {
                            action = true;
                            pb2push = false;
                            tempMode = false;//themometer change to C    
                            break;
                        }
                        led1 = !led1;
                        wait(.5);
                    }
                    uLCD.cls();
                } else if (pb2push) { //this is going to change the time of day.
                    pb2push = false;
                    uLCD.cls();
                    setPassword();
                } else if (pb3push) {
                    pb3push = false;
                    bluetoothOn();
                    
                }
            }
                uLCD.cls();
                led1 =1;
                led2 =1;
                pb4push = false;
        }   else {
           float temp = myTMP36.read();
           if (tempMode) {
                temp = (temp * 1.8) + 32; 
            }
            if (locked) {
                uLCD.text_height(4);
                uLCD.color(RED);
                uLCD.locate(4,0);
                uLCD.printf("Locked");
                uLCD.color(WHITE);
                uLCD.text_height(3);
                uLCD.locate(1,2);
                char buffer[32];
                strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
                uLCD.printf("Time %s",buffer);
                uLCD.locate(1,4);
                if (tempMode) {
                    uLCD.printf("Temp %3.2f F",temp);   
                } else {
                    uLCD.printf("Temp %3.2f C",temp);
                }
                wait(2);
                //uLCD.cls();    
            } else {
                uLCD.text_height(4);
                uLCD.color(GREEN);
                uLCD.locate(4,0);
                uLCD.printf("Unlocked");
                uLCD.color(WHITE);
                uLCD.text_height(3);
                uLCD.locate(1,2);
                char buffer[32];
                strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
                uLCD.printf("Time %s",buffer);
                uLCD.locate(1,4);
                if (tempMode) {
                    uLCD.printf("Temp %3.2f F",temp);   
                } else {
                    uLCD.printf("Temp %3.2f C",temp);
                }
                wait(2);
                //uLCD.cls();    
                    
            }
            
        }  
     
    }
}
