#include "mbed.h"
#include "USBSerial.h"

USBSerial pc;

DigitalOut ASIC_CS(P0_2);
DigitalOut DAC_CS(P1_26);
DigitalOut DAC_LDAC(P1_14);
DigitalOut DAC_SHDN(P1_15);
DigitalInOut PD_CHA(P0_21);


AnalogIn DAC_OUT_A(P0_11);
AnalogIn DAC_OUT_B(P0_12);
AnalogIn OUT_N(P0_13);
AnalogIn OUT_P(P0_14);
AnalogIn BG_BUF(P0_15);
AnalogIn PHOTO_DIODE(P0_22);

PwmOut SWITCH(P1_24); // shorts the op-amp feedback network when high 24
//PwmOut EXTCLK(P1_25); // can be used to apply an external clock to the ASIC if needed (need to solder to P0_20 (if actually required) due to mistake)

SPI ASIC(P0_9, P0_8, P1_29);//MOSI, MISO, SCLK
SPI DAC(P1_22, P1_21, P1_20);// MOSI, MISO, SCLK

int ASIC_SPI_REGISTER;
char command, p1, p2, p3, p4;
void variable_defaults()
{
   ASIC_SPI_REGISTER = (0x0000);
   ASIC_CS=1;
   DAC_CS=1;
   DAC_LDAC=0;
   DAC_SHDN=0; //Disable DAC
   PD_CHA.input();
   PD_CHA.mode(PullNone);
}

void connect_PD_CHA(int value)//connect power down and drive to value
{
   PD_CHA.output();
   PD_CHA = value; 
}

void disable_DAC()
{
    DAC_SHDN=0;
}

void disconnect_PD_CHA()
{
   PD_CHA.input();
   PD_CHA.mode(PullNone);
}

int Set_DAC_A(int desired_value_A) // sets the value of MCP4922 DAC channel A
{
       // int desired_value_A = (voutA/3.3)*4096;
       DAC_SHDN=1; //Enable DAC
        char command_register_msb = (0x70);// 01110000 for DAC A, BUF, Gain =1  and no shutdown
        command_register_msb = ((command_register_msb)|desired_value_A>>8); // assign first 4 bits to first byte to send
        char command_register_lsb = desired_value_A; // assign last 8 bits to second byte to send
        DAC_CS =0; // bring CS low
        int junk= DAC.write(command_register_msb); // write first byte
        junk= DAC.write(command_register_lsb); // write second byte
        DAC_CS=1;                               // De-select device 
        return 1;
}

int Set_DAC_B(int desired_value_B) // sets the value of MCP4922 DAC channel B
{
       // int desired_value_B = (voutB/3.3)*4096;
       DAC_SHDN=1; //Enable DAC
        char command_register_msb = (0xF0);// 11110000 for DAC B, BUF, Gain =1  and no shutdown
        command_register_msb = ((command_register_msb)|desired_value_B>>8); // assign first 4 bits to first byte to send
        char command_register_lsb = desired_value_B; // assign last 8 bits to second byte to send
        DAC_CS =0; // bring CS low
        int junk= DAC.write(command_register_msb); // write first byte
        junk= DAC.write(command_register_lsb); // write second byte
        DAC_CS=1;                               // De-select device 
        return 1;
}

void Send_ASIC_SPI(char to_send)
{
    ASIC_CS=0;
    int junk = ASIC.write(to_send);
    ASIC_CS=1;
}

void ExternalClock(float duty_cycle, int period_us)
{
    //EXTCLK.write(duty_cycle);
   // EXTCLK.period_us(period_us);
}

void SWITCH_SET(float duty_cycle, int period_us)
{
    SWITCH.write(duty_cycle);
    SWITCH.period_us(period_us);
}

int main() {
    variable_defaults();
    Set_DAC_A(0);
    Set_DAC_B(0);
    ExternalClock(0.0, 1000);
    SWITCH_SET(10,255);
    ASIC.format(8, 1);// the ASIC should operate in SPI mode 1
  //  PHOTODIODE.mode(PullNone);
    while(1) {
        if (pc.readable()){
        command = pc.getc();   // Data from PC (command)
        p1 = pc.getc();   // Data from PC (param p1)
        p2 = pc.getc();   // Data from PC (param p2)
        p3 = pc.getc();   // Data from PC (param p2)
        p4 = pc.getc();   // Data from PC (param p2)
        int scrap = pc.getc();    // Carriage Return

        if (command=='A') // update ASIC SPI REGISTER
        {
         ASIC_SPI_REGISTER=0x0000; //clear register
         ASIC_SPI_REGISTER = ASIC_SPI_REGISTER|p2<<16;
         ASIC_SPI_REGISTER = ASIC_SPI_REGISTER|p3<<8;
         ASIC_SPI_REGISTER = ASIC_SPI_REGISTER|p4;
         Send_ASIC_SPI((p2));
         Send_ASIC_SPI((p3));
         Send_ASIC_SPI((p4));
        // pc.printf("%d\n",ASIC_SPI_REGISTER);
        // pc.printf("%d\n",0xff&(ASIC_SPI_REGISTER>>16));
        // pc.printf("%d\n",0xff&(ASIC_SPI_REGISTER>>8));
        // pc.printf("%d\n",0xff&(ASIC_SPI_REGISTER));
        }
        else if (command=='a') // set vouta of DAC
        {
        int desired_value = ((0x0f)&p3)<<8;
        desired_value = desired_value|p4;    
        Set_DAC_A(desired_value);
       // pc.printf("%d\n",desired_value);
        }
        else if (command=='b') // set voutb of DAC
        {
        int desired_value = ((0x0f)&p3)<<8;
        desired_value = desired_value|p4;    
        Set_DAC_B(desired_value);
        }
        else if(command=='C')// read all analog inputs
        {
        pc.printf("%f,%f,%f,%f,%f,%f\n", DAC_OUT_A.read(), DAC_OUT_B.read(), OUT_N.read(), OUT_P.read(), BG_BUF.read(), PHOTO_DIODE.read());
        }
        else if(command=='K')// set external clock
        {
        //   float duty_cycle = (float)p3/ (float)256; // duty cycle
        //  int period_us = p4; //period in microseconds    
        //  ExternalClock(duty_cycle, period_us);
        // pc.printf("%f, %d, %d, %d, %d, %d\n", duty_cycle, period_us, p1, p2, p3, p4);
        }
        else if(command=='S')// set switching settings
        {
        float duty_cycle = (float)p3/ (float)256; // duty cycle
        int period_us = p4; //period in microseconds    
        SWITCH_SET(duty_cycle, period_us);
       // pc.printf("%f, %d\n", duty_cycle, period_us);
       // pc.printf("%f, %d, %d, %d, %d, %d\n", duty_cycle, period_us, p1, p2, p3, p4);
        }        
        else if(command=='P')
        {
            connect_PD_CHA(1);
        }
        else if(command=='p')
        {
            connect_PD_CHA(0);
        }
        else if(command=='O')
        {
            disconnect_PD_CHA();
        }
        else if(command=='d')
        {
          disable_DAC();  
        }     
      }  
    }
}
