#include "mbed.h"
#include "USBSerial.h"

USBSerial pc;

DigitalOut ASIC_CS(P0_2);
DigitalOut CNV_ADC(P1_26);





SPI ASIC(P0_9, P0_8, P1_29);//MOSI, MISO, SCLK
SPI ADC(P1_22, P1_21, P1_20);// MOSI, MISO, SCLK //ADC LTC2311-16


int sixteen_bit_result;
int ASIC_SPI_REGISTER;
char command, p1, p2, p3, p4;
void variable_defaults()
{
   ASIC_SPI_REGISTER = (0x0000);
   ASIC_CS=1;
   CNV_ADC=1;
}


int READ_ADC() // sets the value of MCP4922 DAC channel A
{
        int response= ADC.write(0); // write byte
        return response;
}


void Send_ASIC_SPI(char to_send)
{
    ASIC_CS=0;
    int junk = ASIC.write(to_send);
    ASIC_CS=1;
}

int main() {
    variable_defaults();
    ASIC.format(8, 1);// the ASIC should operate in SPI mode 1
    ADC.format(16, 2);// the ADC should operate in SPI mode 3
    
    while(1) {
        if (pc.readable()){
        command = pc.getc();   // Data from PC (command)
        p1 = pc.getc();   // Data from PC (param p1)
        p2 = pc.getc();   // Data from PC (param p2)
        p3 = pc.getc();   // Data from PC (param p2)
        p4 = pc.getc();   // Data from PC (param p2)
        int scrap = pc.getc();    // Carriage Return

        if (command=='A') // update ASIC SPI REGISTER
        {
         ASIC_SPI_REGISTER=0x0000; //clear register
         ASIC_SPI_REGISTER = ASIC_SPI_REGISTER|p2<<16;
         ASIC_SPI_REGISTER = ASIC_SPI_REGISTER|p3<<8;
         ASIC_SPI_REGISTER = ASIC_SPI_REGISTER|p4;
         Send_ASIC_SPI((p2));
         Send_ASIC_SPI((p3));
         Send_ASIC_SPI((p4));
        // pc.printf("%d\n",ASIC_SPI_REGISTER);
        // pc.printf("%d\n",0xff&(ASIC_SPI_REGISTER>>16));
        // pc.printf("%d\n",0xff&(ASIC_SPI_REGISTER>>8));
        // pc.printf("%d\n",0xff&(ASIC_SPI_REGISTER));
        }
        else if (command=='a') // read adc value
        {
         pc.printf("%d,%d\n",(sixteen_bit_result>>8)&0xff,(sixteen_bit_result&0xff));
        }

      }  
      else
      {
          //CNV_ADC=0;
         // wait_us(100);
        // pc.printf("reading adc...\n");   
         //sixteen_bit_result = 0;
        CNV_ADC=1;
        //wait_us(1);
        CNV_ADC=0;
        sixteen_bit_result = ADC.write(0);
        //wait_us(1);
        CNV_ADC=1;
        //ADC.format(16, 0);// the ADC should operate in SPI mode
          }
          
    }
}
