/***********************************************************************
                                                            PROJECT IRIS
                                            Multidisciplinary Group Project
                        ENG701S2 (Year 4 - MENG) at the University of Portsmouth
        
        Filename:   main.h
        
        Description:    Header file for the main root source file (main.cpp).
        
        Original Created:   05/04/2015
        Original Author:    Jonathan Ashworth
        
        --------------------------Change Log--------------------------------
            Date        |               Author              |                   Details
        06/04/05        Jonathan Ashworth           
        
***********************************************************************/    

/*

void serialTx (void);
void usbTimeout(void);
void shutdown(void);
void serialRx_ISR(void);
void usbTimer_ISR(void);


if(0) {
        
        //servos
        for (i=0; i<PC_SERVO_REQUEST_COUNT; i++) {
            PCRxData[(15*i)+0] = 0x00; //CID
            PCRxData[(15*i)+1] = i+2; //SID
            PCRxData[(15*i)+2] = 0x03;  //FC
            PCRxData[(15*i)+3] = 0x00;  //Byte0...
            PCRxData[(15*i)+4] = 0x00; //.
            PCRxData[(15*i)+5] = 0x00; //.
            PCRxData[(15*i)+6] = 0x00; //...
            PCRxData[(15*i)+7] = 0x00;  //Byte1...
            PCRxData[(15*i)+8] = 0x00; //.
            PCRxData[(15*i)+9] = 0x00; //.
            PCRxData[(15*i)+10] = 0x00; //...
            PCRxData[(15*i)+11] = 0x00; //Byte2...
            PCRxData[(15*i)+12] = 0x00; //.
            PCRxData[(15*i)+13] = 0x00; //.
            PCRxData[(15*i)+14] = 0x00; //...
        }
        
        //motors
        for (i=0; i<PC_MOTOR_REQUEST_COUNT; i++) {
            PCRxData[(7*15)+(7*i)+0] = 0x00; //CID
            PCRxData[(7*15)+(7*i)+1] = i+9; //SID
            PCRxData[(7*15)+(7*i)+2] = 0x01;    //FC
            PCRxData[(7*15)+(7*i)+3] = 0x00;    //Byte0...
            PCRxData[(7*15)+(7*i)+4] = 0x00; //.
            PCRxData[(7*15)+(7*i)+5] = 0x00; //.
            PCRxData[(7*15)+(7*i)+6] = 0x00; //...
        }
        
        PCRxData[(7*15)+(7*i)+0] = 0x00; //CID
        PCRxData[(7*15)+(7*i)+1] = 0x01; //SID
        PCRxData[(7*15)+(7*i)+2] = 0x03;    //FC
        PCRxData[(7*15)+(7*i)+3] = 0x02;    //Byte0...
        PCRxData[(7*15)+(7*i)+4] = 0x0a;
        PCRxData[(7*15)+(7*i)+5] = 0x0d;
        flags.rxNewData = 1;
    
    }

*/

#ifndef MAIN_H
#define MAIN_H

#include "mbed.h"
#include "MODDMA.h"
#include "MODSERIAL.h"
#include "botStateHandler.h"
//#include "HCSR04/HCSR04.h"

#define SERVO_ARM_BASE_CHAN 0
#define SERVO_ARM_SHOULDER_CHAN 1
#define SERVO_ARM_ELBOW_CHAN 2
#define SERVO_ARM_WRIST_CHAN 3
#define SERVO_ARM_MANIPULATOR_CHAN 4
#define SERVO_VISION_PITCH_CHAN 5
#define SERVO_VISION_YAW_CHAN 6
#define SERVO_POSITION_MIN 600
#define SERVO_POSITION_MAX 2300
#define SERVO_POSITION_CENTRE 1500

#define SID_PC 0x00
#define SID_MBED 0x01
#define SID_ARM_BASE 0x02
#define SID_ARM_SHOULDER 0x03
#define SID_ARM_ELBOW 0x04
#define SID_ARM_WRIST 0x05
#define SID_ARM_MANIPULATOR 0x06
#define SID_VISION_PITCH 0x07
#define SID_VISION_YAW 0x08
#define SID_DRIVE_NS 0x09
#define SID_DRIVE_OS 0x0a
#define SID_RESERVED 0x0b
#define SID_9DOF_ACC 0x0c
#define SID_9DOF_GYRO 0x0d
#define SID_9DOF_MAG 0x0e
#define SID_GPS 0x0f
#define SID_TEMP 0x10
#define SID_HUM 0x11
#define SID_BATT_VOL 0x12
#define SID_BATT_CUR 0x13
#define SID_PIR 0x14
#define SID_USOUND_1 0x15
#define SID_USOUND_2 0x16
#define SID_USOUND_3 0x17
#define SID_USOUND_4 0x18
#define SID_USOUND_5 0x19
#define SID_USOUND_6 0x1a
#define SID_FIRSTSERVO_LOCATION 0x02
#define SID_LASTSERVO_LOCATION 0x08
#define SID_FIRSTMOTOR_LOCATION 0x09
#define SID_LASTMOTOR_LOCATION 0x0a
#define SID_FIRSTUSOUND_LOCATION 0x15
#define SID_LASTUSOUND_LOCATION 0x1a

#define PC_BAUDRATE 115200
#define PC_TX_BUFFER_SIZE 1024
#define PC_RX_BUFFER_SIZE 1024
#define PC_TX_PIN USBTX     //Serial tx
#define PC_RX_PIN USBRX     //Serial rx
#define PC_TIMEOUT_MESSAGE "MBED detected a timeout - eStop!"
#define PC_TIMEOUT_PERIOD 200
#define PC_BEGIN_PHRASE "IRIS:INIT"
//const char PC_BEGIN_PHRASE[] = {"IRIS:INIT"};
//#define PC_TERMINATION_PHRASE 0xefffffff  //Packet termination sequence
const unsigned int PC_TERMINATION_PHRASE = 0xefffffff;
#define PC_SERVO_REQUEST_LENGTH 15 // Length of a write request
#define PC_MOTOR_REQUEST_LENGTH 7 // Length of a write request
#define PC_USOUND_RESPONSE_LENGTH 7
#define PC_PIR_RESPONSE_LENGTH 7
#define PC_BATTCURRENT_RESPONSE_LENGTH 7
#define PC_BATTVOLTAGE_RESPONSE_LENGTH 7
#define PC_HUMIDITY_RESPONSE_LENGTH 7
#define PC_TEMPERATURE_RESPONSE_LENGTH 7
#define PC_GPS_RESPONSE_LENGTH 15
#define PC_9DOFACC_RESPONSE_LENGTH 15
#define PC_9DOFGYR_RESPONSE_LENGTH 15
#define PC_9DOFMAG_RESPONSE_LENGTH 15
#define PC_SERVO_REQUEST_COUNT 7 // Number of servo write requests avaliable
#define PC_MOTOR_REQUEST_COUNT 2 // Number of motor write requests avaliable
#define PC_SENTENCE_COUNT 0x0a
#define PC_CID_LOCATION 0
#define PC_SID_LOCATION 1
#define PC_FIELDCOUNT_LOCATION 2
#define PC_FLOAT0_LOCATION 3
#define PC_FLOAT1_LOCATION 7
#define PC_FLOAT2_LOCATION 11
#define PC_REQUESTEDSID_BYTE0_LOCATION 3
#define PC_CID_LENGTH 1
#define PC_SID_LENGTH 1
#define PC_FIELDCOUNT_LENGTH 1
#define PC_LONGESTRESPONSESENTENCE PC_SERVO_REQUEST_LENGTH
#define PC_REQUESTEDSID_MAXCOUNT 512

#define SSC32_BAUDRATE 115200
#define SSC32_TX_BUFFER_SIZE 512
#define SSC32_RX_BUFFER_SIZE 512
#define SSC32_TX_PIN p13    //Serial tx
#define SSC32_RX_PIN p14    //Serial rx
#define SSC32_STOP "\e"     //Command to stop previous command
#define SSC32_STOPPOSITION_ARM_BASE 1500
#define SSC32_STOPPOSITION_ARM_SHOULDER 600
#define SSC32_STOPPOSITION_ARM_ELBOW 2350
#define SSC32_STOPPOSITION_ARM_WRIST 2300
#define SSC32_STOPPOSITION_ARM_MANIPULATOR 1500
#define SSC32_STOPPOSITION_VISION_PITCH 1500
#define SSC32_STOPPOSITION_VISION_YAW 1500
#define SSC32_STOPPOSITION_TIME 4000    // TODO: replace with speed

#define GPS_BAUDRATE 115200
#define GPS_TX_BUFFER_SIZE 512
#define GPS_RX_BUFFER_SIZE 512
#define GPS_TX_PIN p28  //Serial tx
#define GPS_RX_PIN p27  //Serial rx

/* XBEES NOT INCLUDED IN SOLUTION (Recommend a pro version with I2C support)
#define XBEE_TX_BUFFER_SIZE 512
#define XBEE_RX_BUFFER_SIZE 512
#define XBEE_TX_PIN 0   //PIN UNALLOCATED
#define XBEE_RX_PIN 0   //PIN UNALLOCATED
*/

#define ULTRASOUND_TRIGGER_PIN p11//Digital out
#define ULTRASOUND_ECHO_PIN p12     //Digital (PWM) in (from mux common)
#define BATTERY_VOLTAGE_PIN p16     //Analogue in
#define BATTERY_CURRENT_PIN p15     //Analogue in
#define MUX_D0_PIN p5           //Digital out
#define MUX_D1_PIN p6           //Digital out
#define MUX_D2_PIN p7           //Digital out
#define MUX_D3_PIN p8           //Digital out
#define I2C_SDA p9              //I2C data line
#define I2C_SCL p10             //I2C clock line
#define PIR_PIN p20             //Digital in
#define DRIVE_NS_PIN p21    //PWM out
#define DRIVE_OS_PIN p22    //PWM out
#define DRIVE_DEMAND_MIN 1
#define DRIVE_DEMAND_MAX -1
#define DRIVE_DEMAND_NEUTRAL 0 //Demand value for neutral

#define BOTDATA_FIELDNUMBER_SERVO_CHANNEL 0
#define BOTDATA_FIELDNUMBER_SERVO_POSITION 1
#define BOTDATA_FIELDNUMBER_SERVO_SPEED 2
#define BOTDATA_FIELDNUMBER_SERVO_TIME 3
#define BOTDATA_FIELDNUMBER_9DOF_ACCEL_X 1
#define BOTDATA_FIELDNUMBER_9DOF_ACCEL_Y 2
#define BOTDATA_FIELDNUMBER_9DOF_ACCEL_Z 3
#define BOTDATA_FIELDNUMBER_9DOF_MAG_X 1
#define BOTDATA_FIELDNUMBER_9DOF_MAG_Y 2
#define BOTDATA_FIELDNUMBER_9DOF_MAG_Z 3
#define BOTDATA_FIELDNUMBER_9DOF_GYRO_X 1
#define BOTDATA_FIELDNUMBER_9DOF_GYRO_Y 2
#define BOTDATA_FIELDNUMBER_9DOF_GYRO_Z 3
#define BOTDATA_FIELDNUMBER_GPS_LAT 1
#define BOTDATA_FIELDNUMBER_GPS_LONG 2
#define BOTDATA_FIELDNUMBER_GPS_SPEED 3
#define BOTDATA_FIELDNUMBER_TEMPERATURE 1
#define BOTDATA_FIELDNUMBER_HUMIDITY 1
#define BOTDATA_FIELDNUMBER_VOLTAGE 1
#define BOTDATA_FIELDNUMBER_CURRENT 1
#define BOTDATA_FIELDNUMBER_PIR 1
#define BOTDATA_FIELDNUMBER_DRIVE_DEMAND 0
#define BOTDATA_FIELDNUMBER_USOUND_DISTANCE 0

#define BYTELENGTH_OF_A_FLOAT 4
#define BYTELENGTH_OF_AN_INT 4
#define BITLENGTH_OF_A_BYTE 8

enum servoStatus {ToBeMoved = 0, Moving = 1, InPosition = 2};
enum dataErrors {Timeout = 0, RequestDataBad = 1};

struct Flags
{
    bool rxNewData;
    bool txNewData;
    bool txSentData;
    bool PCTimeout;
    bool PCBegin;
};

void initialise(void);
//void getServoData(Servo *servo);
//void readUltrasound(UltrasoundSensor *sensor);
void constructTxData(char *SIDs, char numberOfSensors);
void parseRequestData(void);
unsigned int translateMotorDemandToPWM(float demand);
void PCTimeout(void);
void shutdown(void);
void timerISR(void);
void dmaPCSerialRx(MODSERIAL_IRQ_INFO *q);
bool string_compare(char *a, char *b, unsigned int length);
void sendPCSerialData(void);
void dmaSSC32SerialRx(MODSERIAL_IRQ_INFO *q);
void dmaGPSSerialRx(MODSERIAL_IRQ_INFO *q);
long readUltrasound(void);

#endif /* MAIN_H */
