/* 
 * File:   botStateHandler.cpp
 * Author: jhudson
 * 
 * Created on 25 March 2015, 13:31
 */

/*
 * The bot state handler essentially acts as a central storage facility holding 
 * all of the information about the robots sensors.
 */

#include "botStateHandler.h"
botStateHandler::botStateHandler()
{
    //This initialiser will not intialise data for stations 0 or 1 
    //because these are not sensors.
    
    //This is a dirty hack.This data comes from the shared definition.
    unsigned char fieldCounts[24] = 
    {3,3,3,3,3,3,3,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1};
    
    for(int i = 0; i < 24; i++)
    {
        sensors[i].fieldCount = fieldCounts[i];
        
        //Initialise the fields to nowt.
        for(int j = 0; j < 10; j++) sensors[i].fields[j] = 0.0f;
    }
}

//Allows caller to retrieve values that represent the state of the machine.
int botStateHandler::getVal(unsigned char stationId, unsigned char fieldId, float* val)
{
    if(stationId > 1)
    {
        *val = sensors[stationId - 2].fields[fieldId];
        return 0;
    } else return 1;
}

//Allows caller to set values that represent the state of the machine.
int botStateHandler::setVal(unsigned char stationId, unsigned char fieldId, float* val)
{
    if(stationId > 1)
    {
        sensors[stationId - 2].fields[fieldId] = *val;
        return 0;
    } else return 1;
}
