/*--------------------------------ライブラリ------------------------------------*/
//
// 以下の3つのライブラリを使用するので、それぞれのライブラリをImportする。
// (1) EthernetInterface
// (2) mbed-rtos
// (3) TextLCD

#include "mbed.h"//20170621 バージョン固定
#include "LPC17xx.h"//LPCExpresso
#include "LcdAcm1602ni.h"
#include "string.h"
#include <limits.h>
//#include "TextLCD.h"

/*-----------------------------------定義--------------------------------------*/

//MOTOR
#define CW 0
#define CCW 1


//MLED
#define OFF 0
#define ON  1


/*--------------------------------ピン定義-------------------------------------*/    

//MLED mbed内LEDの設定
DigitalOut mled0(LED1);
DigitalOut mled1(LED2);
DigitalOut mled2(LED3);
DigitalOut mled3(LED4);

//TextLCD lcd(p24, p26, p27, p28, p29, p30);
LcdAcm1602ni lcd(p28,p27);// sda,scl

//インターフェイス
//LED
//DigitalOut open_led(p9);
//DigitalOut close_led(p10);
DigitalOut open_signal(p9);
DigitalOut close_signal(p10);
//スイッチ
DigitalIn close_sw(p19);
DigitalIn open_sw(p20);

//モーター① 入出力ピン
DigitalOut  ccw_pwm(p21);//CW方向へ回転 
DigitalOut  cw_pwm(p22);//CCW方向へ回転
DigitalIn close_limit(p15);
DigitalIn open_limit(p16);
DigitalIn tim(p17);


//モーター②
DigitalOut  ccw_pwm_1(p11);//CW方向へ回転 
DigitalOut  cw_pwm_1(p12);//CCW方向へ回転
DigitalIn close_limit_1(p7);
DigitalIn open_limit_1(p8);
DigitalIn tim1(p18);

//マスター判別ピン
DigitalIn master_pin(p23);

Ticker flipper;
Serial pc(USBTX,USBRX);
/*-------------------------------グローバル変数---------------------------------*/
 
long wt = 800;//モーターパルス用変数 wt = 周期T/2 max500
int dir = 1;
int master_flg = 0;
float tim_pulse = 0;
float tim1_pulse = 0;
float last_tim = 0;
float last_tim1 = 0;
float tim_d = 0;
float tim1_d = 0;;
int tim_arry[30] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
int tim1_arry[30] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

/*-----------------------------------step-------------------------------------*/
//モーターに1パルスを与える
void step(){
    mled3 = ON;
    //open
      if(dir == CW){
        mled2 = ON;
       if(master_flg == 1 && open_limit == OFF){
        //if(master_flg == 1 && close_limit == ON){
           open_signal = OFF;
        }else{
            cw_pwm = ON;
            cw_pwm_1 = ON;
        }
        wait_us(wt);
        cw_pwm = OFF;
        cw_pwm_1 = OFF;
        wait_us(wt);
      }
        //close
      if(dir == CCW){
        mled1 = ON;
        if(master_flg == 1 && close_limit == OFF){
        //if(master_flg == 1 && open_limit == ON){
            close_signal = OFF;
        }else{
            ccw_pwm = ON;
            ccw_pwm_1 = ON;
        }
        wait_us(wt);
        ccw_pwm = OFF;
        ccw_pwm_1 = OFF;
        wait_us(wt);
      }
      mled1 = OFF;
      mled3 = OFF;
}

/*-----------------------------flip 割り込み----------------------------------------*/
void flip(){
      tim_pulse = tim.read();
      tim1_pulse = tim1.read();
      tim_d = last_tim - tim_pulse;
      tim1_d = last_tim1 - tim1_pulse; 
      last_tim = tim_pulse;
      last_tim1 = tim1_pulse;
}

/*-----------------------------MotorContoroll---------------------------------*/
/*20180130
void motorControll(){
    mled3 = ON;
    lcd.initialize();
    lcd.locate(0,0);
    lcd.printf("  ***STATE***");
    while(open_sw == ON||close_sw == ON){
      if(open_limit == ON && close_limit == ON){
        open_led = OFF;
        close_led = OFF;
      }
      if(open_limit == OFF && open_limit_1 == OFF && open_sw == ON){
        lcd.locate(1,0);
        lcd.printf("open");
        open_led = ON;
      } 
      if(close_limit == OFF && close_limit_1 == OFF && close_sw == ON){
        lcd.locate(1,0);
        lcd.printf("close");
        open_led = ON;
        close_led = ON;
      }
      step();
    }
    mled3 = OFF;
*/
//timパルス実装検討中
void motorControll(){
    mled2 = ON;
    while(open_sw == ON||close_sw == ON){    
        step();
    }
    mled2 = OFF;
}


/*---------------------------------main---------------------------------------*/

int main(){
//LCD初期化   
/*
    lcd.initialize();
    lcd.locate(0,0);
    lcd.printf("*AutoSlideCover*");
    pc.printf("*AutoSlideCover*");
    lcd.locate(1,0);
    lcd.printf("setup....");
    pc.printf("setup....");
*/
//ピンモード初期化
    open_sw.mode(PullDown);
    close_sw.mode(PullDown);
    open_limit.mode(PullDown);
    open_limit_1.mode(PullDown);
    close_limit.mode(PullDown);
    close_limit_1.mode(PullDown);
    tim.mode(PullDown);
    tim1.mode(PullDown);
    master_pin.mode(PullDown);
    
//    tim.mode(PullNone);
//    tim1.mode(PullNone);
//    wait(2.0);

//    lcd.locate(1,0);
//    lcd.printf("complete!");
//      pc.printf("complete!\n");
//    wait_ms(100);
    
    if(master_pin == ON){
        master_flg = 1;
        mled0 = ON;
    }
    int open_buf[10]={0,0,0,0,0,0,0,0,0,0};
    int close_buf[10]={0,0,0,0,0,0,0,0,0,0};
    
 /*   
     if(close_limit == ON && close_limit_1 == ON){
            lcd.initialize();
            lcd.locate(0,0);
            lcd.printf("  ***STATE***");
        }
        if(open_limit == ON && open_limit_1 == ON){
            lcd.initialize();
            lcd.locate(0,0);
            lcd.printf("  ***STATE***");
        }
        if(close_limit == OFF && close_limit_1 == OFF){
            lcd.initialize();
            lcd.locate(0,0);
            lcd.printf("  ***STATE***");
            lcd.locate(1,0);
            lcd.printf("close");
        }
        if(open_limit == OFF && open_limit_1 == OFF){
            lcd.initialize();
            lcd.locate(0,0);
            lcd.printf("  ***STATE***");
            lcd.locate(1,0);
            lcd.printf("open");
        }
*/   
    while(1){
//        if(open_limit == 1)pc.printf("open_limit\n");
//        if(close_limit == 1)pc.printf("close_limit\n");
//        if(open_limit_1 == 1)pc.printf("open_limit_1\n");
//        if(close_limit_1 == 1)pc.printf("close_limit_1\n");
        if(master_flg == 0){
            if(open_sw == ON){
                mled0 = ON;
                dir = CW;
                motorControll();
                mled0 = OFF;
            }
            if(close_sw == ON){
                mled1 = ON;
                dir = CCW;
                motorControll();
                mled1 = OFF;
            }
        }else if(master_flg == 1){
            mled1 = OFF;
            mled2 = OFF;
            mled3 = OFF;
            int open_sum = 0;
            int close_sum = 0;
            for(int i=0;i<10;i++){
                open_buf[i] = open_sw;
                close_buf[i] = close_sw;
                wait_ms(50);
            }
            for(int j=0;j<10;j++){
                open_sum = open_sum + open_buf[j];
                close_sum = close_sum + close_buf[j];
            }
            if(open_sum == 10){
                dir = CW;
                open_signal = ON;
                motorControll();
                open_signal = OFF;
            }
            if(close_sum == 10){
                dir = CCW;
                close_signal = ON;
                motorControll();
                close_signal = OFF;
            }
        } 
    }
}