#include "mbed.h"
#include "Helios.h"

/*------------------------------------------------------------------------------
Before to use this example, ensure that you an hyperterminal installed on your
computer. More info here: https://developer.mbed.org/handbook/Terminals

The default serial comm port uses the SERIAL_TX and SERIAL_RX pins (see their
definition in the PinNames.h file).

The default serial configuration in this case is 9600 bauds, 8-bit data, no parity

If you want to change the baudrate for example, you have to redeclare the
serial object in your code:

Serial pc(SERIAL_TX, SERIAL_RX);

Then, you can modify the baudrate and print like this:

pc.baud(115200);
pc.printf("Hello World !\n");
------------------------------------------------------------------------------*/

DigitalOut led(LED1);
Helios sun;

int main()
{
    time_t seconds;
    char buffer[32];

    printf("Hello World !\n");
    set_time(1529836800);    
    while(1) {
        wait(1); // 1 second
        led = !led; // Toggle LED
        seconds = time(NULL);
        sun.updatePosition();
        strftime(buffer, 32, "%H:%M:%S", localtime(&seconds));
        printf("UTC time is: %s\n", buffer);
        printf("Sun azimuth: %.2f, elevation: %.2f\n", sun.azimuth(), sun.elevation());
    }
}
