#include "mbed.h"
#include "ili9328.h"
 
SPI device(NC, PC_11, PC_10);
DigitalOut cs(PC_12);
Serial pc(USBTX, USBRX);

BusOut dataBus(PA_5, PA_6, PA_7, PA_8, PA_9, PA_10, PA_11, PA_12, PB_1, PB_2, PB_3, PB_4, PB_5, PB_6, PB_8, PB_9); // 16 pins
ILI9328_LCD lcd(PB_10, PB_12, PB_13, PB_14, &dataBus);

float readTempSensor();

int main() {
    cs = 1;
    pc.printf("Hello...\n");
    
    // initialize display - place it in standard portrait mode and set background to black and
    //                      foreground to white color.
    lcd.Initialize();
    // set current font to the smallest 8x12 pixels font.
    lcd.SetFont( &TerminusFont );
    // print something on the screen
    
    while(1) {
        //wait(1.0f);
        //pc.printf("Temperature: %f\n", readTempSensor());
        lcd.Print( "Hello, World!", CENTER, 25 ); // align text to center horizontally and use starndard colors
    }
}

float readTempSensor()
{
    cs = 0;
    uint8_t byte;
    int result = 0;
    wait_us(1);
    for (int i = 0; i < 4; i++) {
        byte = device.write(0);
        result = (result << 8) | byte;
    }
    cs = 1;
    return (result >> 18) / 4.0f;
}