#include "mbed.h"

DigitalIn A(D15);
DigitalIn B(D14);
Serial pc(USBTX, USBRX);
int counter = 0;

void readEncoder();
void encoderIncrement();
void encoderDecrement();

int main() {
    A.mode(PullNone);
    B.mode(PullNone);
    pc.printf("Hello World.\n\r");
    while(1) {
        readEncoder();
    }
}

void readEncoder()
{
    static int state = 0;
    int currentState;
    const int stateOrder[] = {0, 2, 3, 1};
    const int stateIndex[] = {0, 3, 1, 2};
    int ccwState, cwState;
    
    currentState = (A << 1) + B;
    ccwState = stateOrder[(stateIndex[state] + 3) & 3];
    cwState = stateOrder[(stateIndex[state] + 1) & 3];
    if (currentState == cwState)
        encoderIncrement();
    else if (currentState == ccwState)
        encoderDecrement();
    state = currentState;
}

void encoderIncrement()
{
    counter++;
    pc.printf("Counter is: %d.\n\r", counter);
}

void encoderDecrement()
{
    counter--;
    pc.printf("Counter is: %d.\n\r", counter);    
}