#include "mbed.h"
#include "Pixy.h"

Pixy pixy(Pixy::SPI, D11, D12, D13);
Serial pc(USBTX, USBRX);

int main() {
    pixy.setSerialOutput(&pc);
    while (1) {
        static int i = 0;
        int j;
        uint16_t blocks;
  
        blocks = pixy.getBlocks();
  
        if (blocks) {
            i++;
    
            if (i % 50 == 0) {
                pc.printf("Detected %d:\n\r", blocks);
                for (j = 0; j < blocks; j++) {
                    pc.printf("  block %d: ", j);
                    pixy.blocks[j].print(pc);
                }
            }
        }
    }  
}