#ifndef TUIASI_PIXYLINK_H
#define TUIASI_PIXYLINK_H

#include "stdint.h"

class PixyLink
{
public:
    PixyLink() { m_addr = 0; };
    PixyLink(uint8_t addr) : m_addr(addr) {};
    void setAddress(uint8_t addr) {
        m_addr = addr;
    };
    virtual uint16_t getWord() = 0;
    virtual uint8_t getByte() = 0;
    virtual int8_t send(uint8_t *data, uint8_t len) = 0;
protected:
    uint8_t m_addr;
};

#endif //TUIASI_PIXYLINK_H