#include "mbed.h"

DigitalIn A(D15);
DigitalIn B(D14);
PwmOut squareSignal(D10);
InterruptIn riseEvent(D9);
Serial pc(USBTX, USBRX);
Timer displayTimer;

Timer periodTimer;
Timer freqUpdateTimer;
float period;
float generatorPeriod = 1.0e-3f;
float delta = 50.0e-6f;

void readEncoder();
void onRisingEdge();

int main()
{
    // configuram semnalul dreptunghiular
    // perioada = 1ms
    // latimea pulsului = 0.5ms
    squareSignal.period(generatorPeriod);
    squareSignal = 0.5f;
    
    riseEvent.rise(onRisingEdge);
    periodTimer.start();
    
    displayTimer.start();
    freqUpdateTimer.start();
    while (true) {
        readEncoder();
        if (displayTimer.read() > 0.5f) {
            pc.printf("Frequency: %g, period: %g\n", 1.0f / period, period);
            displayTimer.reset();
        }
        if (freqUpdateTimer.read_us() > 1000) {
            squareSignal.period(generatorPeriod);
            squareSignal = 0.5f;
            freqUpdateTimer.reset();
        }
    }
}

void onRisingEdge()
{
    period = periodTimer.read();
    periodTimer.reset();
}

void readEncoder()
{
    static int state = 0;
    int currentState;
    const int stateOrder[] = {0, 2, 3, 1};
    const int stateIndex[] = {0, 3, 1, 2};
    int ccwState, cwState;
    
    currentState = (A << 1) | B;
    ccwState = stateOrder[(stateIndex[state] + 3) & 3];
    cwState = stateOrder[(stateIndex[state] + 1) & 3];
    if (currentState == cwState)
        encoderIncrement();
    else if (currentState == ccwState)
        encoderDecrement();
    state = currentState;
}

void encoderIncrement()
{
    generatorPeriod += delta;
}

void encoderDecrement()
{
    generatorPeriod -= delta;
}