#ifndef _THREEPHASEBRIDGE_H_
#define _THREEPHASEBRIDGE_H_

#include "mbed.h"
#include "CenteredPwmOut.h"
#include <stdint.h>

class ThreePhaseBridge
{
public:
    enum ActiveState {ActiveLow, ActiveHigh};
    enum SwitchState {Off, On};
    enum Switches {SW2 = 1, SW4 = 2, SW6 = 4, SW1 = 8, SW3 = 16, SW5 = 32};
    enum SpinDirection {CW = 1, CCW = -1};
    ThreePhaseBridge(PinName sw1PinName, PinName sw2PinName, PinName sw3PinName,
                     PinName sw4PinName, PinName sw5PinName, PinName sw6PinName,
                     ActiveState activeState = ActiveLow);
    void period(double seconds);
    void pulsewidth(double seconds);
    inline int8_t state() { return m_state; };
    void setState(int8_t state);
    void spin(SpinDirection dir);
    void stop();
    void setHighSideSwitchState(int8_t sw, SwitchState state);
    void setLowSideSwitchState(int8_t sw, SwitchState state);
    void overflow(void (*fptr)(void));
    
private:
    static int8_t stateOrder[];
    inline void setSwitchesState(uint8_t newState);
    CenteredPwmOut sw1, sw3, sw5;
    DigitalOut sw2, sw4, sw6;
    CenteredPwmOut *highSide[3];
    DigitalOut *lowSide[3];
    ActiveState activeState;
    double pwmPeriod, pwmPulseWidth, pwmPulseWidthOff;
    uint8_t switchesState;
    int8_t m_state, stateIndex;
};

#endif /* _THREEPHASEBRIDGE_H_ */