/*
  Helios.h - Library for calculating the solar
  position.
  Copyright (c) 2011 Hannes Hassler.  All right reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef Helios_h
#define Helios_h


#include <math.h>

// Declaration of some constants
#define pi    3.14159265358979323846
#define twopi (2*pi)
#define rad   (pi/180)
#define dEarthMeanRadius     6371.01    // In km
#define dAstronomicalUnit    149597890  // In km


class Helios
{
public:
    Helios(double latitude=47.15845, double longitude=27.60144, int tzOffset=0);
    void updatePosition();
    void setLocalLatitude(double latitude);
    void setLocalLongitude(double longitude);
    void setLocalTimeZoneOffset(int tzOffset);
    double azimuth();
    double elevation();
private:
    int iTzOffset;
    double dLongitude;
    double dLatitude;
    double dCos_Latitude;
    double dSin_Latitude;

    double dAzimuth;
    double dElevation;
};
#endif