#ifdef TARGET_KLXX

#include "CenteredPwmOut.h"
#include "PeripheralPins.h"

CenteredPwmOut::CenteredPwmOut(PinName pin):
    PwmOut(pin)
{
    PWMName pwm = (PWMName)pinmap_peripheral(pin, PinMap_PWM);
    if (pwm == (PWMName)NC)
        return;
    unsigned int tpm_n = (pwm >> TPM_SHIFT);
    
    TPM_Type *tpm = (TPM_Type *)(TPM0_BASE + 0x1000 * tpm_n);

    // Enable PWM interrupts
    tpm->SC |= TPM_SC_TOIE_MASK;

    unsigned int clkdiv = (tpm->SC & TPM_SC_PS_MASK) >> TPM_SC_PS_SHIFT;
    bool centered = tpm->SC & TPM_SC_CPWMS_MASK;
    
    if (centered)
        return;
    // Change PWM to center-aligned mode
    
    // First, disable counter
    tpm->SC &= ~TPM_SC_CMOD_MASK;
    // Change the prescaler factor
    //tpm->SC &= ~TPM_SC_PS_MASK;
    //tpm->SC |= TPM_SC_PS(clkdiv - 1);
    // Then change mode
    tpm->SC |= TPM_SC_CPWMS_MASK;
    // Finally, enable counter
    tpm->SC |= TPM_SC_CMOD(1);
}

#endif