// uLCD-144-G2 demo program for uLCD-4GL LCD driver library
//
#include "mbed.h"
#include "uLCD_4DGL.h"
#include "rtos.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalIn  pb1(p24);        //Right
DigitalIn  pb2(p23);        //Left
DigitalIn  pb3(p22);        //Down
DigitalIn  pb4(p21);        //Up
uLCD_4DGL uLCD(p9,p10,p11); //Screen
Mutex key;                  //Pushbutton key

   int i=2;                           //Win variable  
   int x,y;                         //Frogger Location  
   int u,v;                         //Previous Location
   int k=1;                         //Change?
   int l;
   int gametime;                        //Game over condition
   
struct cars
{
    int x;
    int y;
    int u;
    int v;  
};   

struct logs
{
    int x1;
    int x2;
    int x3;
    int y;
    int u1;
    int u2;
    int u3;
    int v;
    int speed;           
};

struct logs brown[5];
struct cars  red[5];

void Print_Background()      //Prints Map
{
    uLCD.filled_rectangle(gametime/12,1,128,5,0x000000);
    if(gametime/12==35){i=0;}
    gametime-=4;
    l+=1;
    l= l%4;
    for(int j=0;j<5;j++)
    {
            switch(red[j].v)                       //Water or land?
        {
            case 12:
            case 11:
            case 10:
            case 9:
            case 8:
            case 7:
            case 6:
            case 0:
            uLCD.filled_rectangle(red[j].u*8,11+(red[j].v*9),(red[j].u*8)+7,19+(red[j].v*9),0x000000);
            break;
            default:
            uLCD.filled_rectangle(red[j].u*8,11+(red[j].v*9),(red[j].u*8)+7,19+(red[j].v*9),0x0000FF);
        }    
        uLCD.filled_rectangle(red[j].x*8,11+(red[j].y*9),(red[j].x*8)+7,19+(red[j].y*9), 0xFF0000);
        red[j].u=red[j].x;
        red[j].v=red[j].y;
        red[j].x= (red[j].x+1)%16;
        if(x==red[j].x&y==red[j].y){i=0;}
        if(x==red[j].u&y==red[j].y){i=0;}
    }
    for(int j=0;j<5;j++)
    {
        if(l==3)
        {
            uLCD.filled_rectangle(brown[j].u1*8,11+(brown[j].v*9),(brown[j].u1*8)+7,19+(brown[j].v*9),0x0000FF);
            uLCD.filled_rectangle(brown[j].u2*8,11+(brown[j].v*9),(brown[j].u2*8)+7,19+(brown[j].v*9),0x0000FF);
            uLCD.filled_rectangle(brown[j].u3*8,11+(brown[j].v*9),(brown[j].u3*8)+7,19+(brown[j].v*9),0x0000FF);
            uLCD.filled_rectangle(brown[j].x1*8,11+(brown[j].y*9),(brown[j].x1*8)+7,19+(brown[j].y*9), 0x660000);
            uLCD.filled_rectangle(brown[j].x2*8,11+(brown[j].y*9),(brown[j].x2*8)+7,19+(brown[j].y*9), 0x660000);            
            uLCD.filled_rectangle(brown[j].x3*8,11+(brown[j].y*9),(brown[j].x3*8)+7,19+(brown[j].y*9), 0x660000);
            brown[j].u1=brown[j].x1;
            brown[j].u2=brown[j].x2;
            brown[j].u3=brown[j].x3;
            brown[j].v=brown[j].y;
            brown[j].x1= (brown[j].x1+brown[j].speed)%16;
            brown[j].x2= (brown[j].x2+brown[j].speed)%16;
            brown[j].x3= (brown[j].x3+brown[j].speed)%16;
        }
        if(y==brown[j].y)
        {
        if(x==brown[j].u1){}
        else if(x==brown[j].u2){}
        else if(x==brown[j].u3){}
        else i=0;
        }

    }
}




void Print_Frogger(int x, int y)    //Print Player
{
    if(k)
    {
        key.lock();                     //Prevents position change as writing onto screen
        switch(v)                       //Water or land?
        {
            case 12:
            case 11:
            case 10:
            case 9:
            case 8:
            case 7:
            case 6:
            case 0:
            uLCD.filled_rectangle(u*8,11+(v*9),(u*8)+7,19+(v*9),0x000000);
            break;
            default:
            uLCD.filled_rectangle(u*8,11+(v*9),(u*8)+7,19+(v*9),0x0000FF);
        }    
        uLCD.filled_rectangle(x*8,11+(y*9),(x*8)+7,19+(y*9),0x00FF00);
        if(y==0){i=1;}
        u=x;
        v=y;
        k=0;
        key.unlock();
    }
}

void Pushbutton_Left(void const *args)          //Check Left to change x
{
    while(1)
    {
        if((x>0)&!pb2&!k)                         //Is it not at the left wall?
        {
            key.lock();
            x-=1;
            Thread::wait(50);    
            k=1;
            key.unlock();   
        }        
    }
}

void Pushbutton_Right(void const *args)         //Check Right to change x
{
    while(1)
    {
        if((x<15)&!pb1&!k)                        //Is it not at the right wall?
        {
            key.lock();
            x+=1;
            Thread::wait(50);  
            k=1;  
            key.unlock();   
        }     
    }
}

void Pushbutton_Up(void const *args)            //Check Up to change y
{
     while(1)
     {
        if((y>0)&!pb4&!k)
        {
            key.lock();
            y-=1;
            Thread::wait(50);    
            k=1;
            key.unlock();           
        }
    }
}

void Pushbutton_Down(void const *args)          //Check Down to change y
{
     while(1)
     {
        if((y<12)&!pb3&!k)
        {
            key.lock();
            y+=1;
            Thread::wait(50);    
            k=1;
            key.unlock();   
        }
    }
}


int main()
{
   pb1.mode(PullUp);                //initiation
   pb2.mode(PullUp);
   pb3.mode(PullUp);      
   pb4.mode(PullUp);
   led1=1;
   led2=1;
   led3=1;
   led4=1;
   uLCD.baudrate(3000000);          //Set Baud at MAX
   
   while(1)
   {
        uLCD.cls();
        switch(i)
        {
            case 2:
            uLCD.printf("Simple Frogger");  //Start Screen
            break;
            case 1:
            uLCD.printf("VICTORY");
            break;
            case 0:
            uLCD.printf("DEFEAT");
        }
        while(pb1&pb2&pb3&pb4)   //Push any button to start
        {
           led1=!led1;
           wait(.1);
           led2=!led2;
           wait(.1);
           led3=!led3;
           wait(.1);
           led4=!led4;
           wait(.1);
        }
        
        uLCD.cls();
        i=2;                    //Reset Win Condition
        x=15;                   //Start at right wall
        u=15;
        y=12;                   //Start at bottom
        v=12;
        l=0;
        gametime=1524;               //Game Over condition
        uLCD.locate(0,0);
        uLCD.printf("Time:");
        uLCD.filled_rectangle(35,1,127,5,0x00FF00);     //Time bar
        uLCD.filled_rectangle(0,20,128,64,0x0000FF);    //Water
        
        for(int j=0; j<5; j++)
        {
            brown[j].x1= rand()%12;
            brown[j].x2= brown[j].x1+1;
            brown[j].x3= brown[j].x1+2;
            brown[j].y= j+1;
            brown[j].u1= brown[j].x1;
            brown[j].u2= brown[j].x2;
            brown[j].u3= brown[j].x3;
            brown[j].v=brown[j].y;
            brown[j].speed= 1+rand()%2;
        }
        
        for(int j=0;j<5;j++)
        {
            red[j].x= rand()%15;
            red[j].y= 7+rand()%6;
            red[j].u=red[j].x;
            red[j].v=red[j].y;
        }

        Thread push1(Pushbutton_Up);
        Thread push2(Pushbutton_Down);
        Thread push3(Pushbutton_Left);
        Thread push4(Pushbutton_Right);
        
        while(i==2)                //Check Win Condition
        {                    
        
            Print_Background();    //Brackground print
            Print_Frogger(x,y);    //Frogger print            
        }

    }   
}



