#include "mbed.h"
#include "EthernetInterface.h"
#include "NokiaLCD.h"

NokiaLCD lcd(p5, p7, p8, p9, NokiaLCD::LCD6610); // mosi, sclk, cs, rst, type
DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");

EthernetInterface eth; //, ethMask, ethNull, ethNull);

typedef struct _data {
    int pan;
    int tilt;
} data;
data real;

char InBound[300]; // incomming data
char OutBound[300]; // outbound data
char outpan[10];
char outtilt[10];
char header[] = "real ";
char space[] = " ";

void BuildOut(data outdata)
{
    htons(outdata.pan);
    htons(outdata.tilt);
    sprintf(outpan, "%d", outdata.pan);
    sprintf(outtilt, "%d", outdata.tilt);
    strncpy(OutBound, header, sizeof(OutBound)-1);
    strcat(OutBound, outpan);
    strcat(OutBound, space);
    strcat(OutBound, outtilt);
}

int main()
{

    eth.init("198.168.1.20","255.255.255.0","0.0.0.0");
    eth.connect();

    TCPSocketServer sock;
    if (sock.bind(80)>=0) {
        led4=1;
    }
    sock.listen(1);
    //create a TCPSocketConnection instance that will handle the incoming connection.
    TCPSocketConnection client;

    while (!client.is_connected()) {
        sock.accept(client);
    }
    led3 = 1;

    while(true) {

        int ret = client.receive(InBound, sizeof(InBound)-1);

        if (ret >=0) {
            led2=1;
            lcd.locate(0,1);
            lcd.printf(InBound);
            // Go head and do stuff the inbound data
            //Now send out your outbound packet with someinformation:
            real.pan = 321;  //as read by your devices
            real.tilt = 654; //as read by your devices
            BuildOut(real);
            lcd.locate(0,0);
            lcd.printf(OutBound);
            client.send(OutBound, sizeof(OutBound));

            ret = -1;
        }
    }
}
//lcd.printf("Values %d %d", real.pan, real.tilt);
//strcat(OutBound, header);

//char test[] = "123 456 789";

//int first, sec, third;
//if (sscanf(InBound, "%d %d %d", &first, &sec, &third) <= 3){
//lcd.locate(0,1);
//lcd.printf("first is %d", first);
//lcd.locate(0,2);
//lcd.printf("Sec is %d", sec);
//lcd.locate(0,3);
//lcd.printf("third is %d", third);
//}
