#include "mbed.h"


#include "mbed_rtc_time.h"

DigitalOut myled(LED1);
InterruptIn user_button(USER_BUTTON);

bool  executeMainTask = false;
Timer user_button_timer, loop_timer;
int   Ts_ms = 50;

/* declaration of custom button functions */
void button_fall();
void button_rise();

int loops_per_second = static_cast<int>(ceilf(1.0f/(0.001f*(float)Ts_ms)));


int main(){
    set_time(1618332129);  // Set RTC time to Wed, 28 Oct 2009 11:35:37
    user_button.fall(&button_fall);
    user_button.rise(&button_rise);
    loop_timer.start();
    
    while(1){
        if(user_button){
        myled = 1;}
        else{
        myled = 0;}
        wait(0.5);
        loop_timer.reset();
        
        

 

        if (executeMainTask) {
            time_t seconds = time(NULL);

        printf("Time as seconds since January 1, 1970 = %u\n", (unsigned int)seconds);

        printf("Time as a basic string = %s", ctime(&seconds));

        char buffer[32];
        strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
        printf("Time as a custom formatted string = %s", buffer);

        //ThisThread::sleep_for(50);
        }}
        
void button_fall()
{
    user_button_timer.reset();
    user_button_timer.start()=08:00;
}

void button_rise()
{
    int t_button_ms = duration_cast<milliseconds>(user_button_timer.elapsed_time()).count();
    user_button_timer.stop();
    if (t_button_ms > 200) {
        executeMainTask = !executeMainTask;
    }