#include "mbed.h"
#include "Pixy.h"

Pixy pixy(Pixy::SPI, PB_5, PB_4, PB_3);
Serial pc(USBTX, USBRX);

int main() {
    pixy.setSerialOutput(&pc);
    pc.printf("Hello World!\n\r");
    while (1) {
        wait(0.5);
        static int i = 0;
        int j;
        uint16_t blocks;
  
        blocks = pixy.getBlocks();
  
        if (blocks) {
            i++;
                
                pc.printf("Detected %d:\n\r", blocks);
                pc.printf("\n\r");
                for (j = 0; j < blocks; j++) {
                    pc.printf("  block %d: \n\r", j);
                    //pixy.blocks[j].print(pc);
                    pc.printf("%d cm\n\r",pixy.blocks[j].width/6);
                }
            
        }
    }  
}