/* NTPClient.h */
/* Copyright (C) 2012 mbed.org, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef NTPCLIENT_H_
#define NTPCLIENT_H_

#include <cstdint>
#include "EthernetInterface.h"
#include "NetworkStack.h"
#include "UDPSocket.h"
#include <inet.h>

using std::uint8_t;
using std::uint16_t;
using std::uint32_t;

#define NTP_DEFAULT_PORT 123
#define NTP_DEFAULT_TIMEOUT 3
#define NTP_CLIENT_PORT 0 //Random port
#define NTP_TIMESTAMP_DELTA 2208988800ull //Diff btw a UNIX timestamp (Starting Jan, 1st 1970) and a NTP timestamp (Starting Jan, 1st 1900)

///NTP client results
enum NTPResult
{
  NTP_DNS = -1, ///<Could not resolve name
  NTP_PRTCL = -2, ///<Protocol error
  NTP_TIMEOUT = -3, ///<Connection timeout
  NTP_CONN = -4, ///<Connection error
  NTP_OK = 1, ///<Success
  NTP_WAIT = 0
};

/** NTP Client to update the mbed's RTC using a remote time server
*
*/
class NTPClient
{
public:
    NTPClient();
    NTPResult setTime(EthernetInterface *stack, const char* host, uint16_t port = NTP_DEFAULT_PORT, uint32_t timeout = NTP_DEFAULT_TIMEOUT); //Blocking
    int update();

private:
    void process_result();
    void reset();
    
    struct NTPPacket //See RFC 4330 for Simple NTP
    {
        //WARN: We are in LE! Network is BE!
        //LSb first
        unsigned mode : 3;
        unsigned vn : 3;
        unsigned li : 2;
        
        uint8_t stratum;
        uint8_t poll;
        uint8_t precision;
        //32 bits header
        
        uint32_t rootDelay;
        uint32_t rootDispersion;
        uint32_t refId;
        
        uint32_t refTm_s;
        uint32_t refTm_f;
        uint32_t origTm_s;
        uint32_t origTm_f;
        uint32_t rxTm_s;
        uint32_t rxTm_f;
        uint32_t txTm_s;
        uint32_t txTm_f;
    } __attribute__ ((packed));
    
    struct NTPPacket pkt;
    UDPSocket m_sock;
    bool mQuerySent;
    bool mResponseReceived;
    bool mConversationComplete;
    int mStartTime;
    int mTimeout;
    SocketAddress* outEndpoint;
    SocketAddress* inEndpoint;
};


#endif

