
#ifndef CONFIGURATION_MANAGER_H_
#define CONFIGURATION_MANAGER_H_

#include "CodeMemory.h"
#include "NTPClient.h"
#include "TFTPClient.h"
#include "DHCPOptions.h"

#define RESET_PAUSE_SECONDS            1.5
#define ACCESS_CODE_MAX_LENGTH         5
#define ACCESS_CODE_MIN_LENGTH         3
#define ACCESS_CODE_PRINT_FORMAT       "%-7u"
#define ACCESS_CODE_NUM_COLS           10
#define USB_RX_MAX_LENGTH              80
#define CONFIG_PARAM_NAME_MAX_LENGTH   8
#define CONFIG_PARAM_VALUE_MAX_LENGTH  30
#define IP_STRING_MAX_LENGTH           15
#define IP_STRING_MIN_LENGTH           7
#define DEFAULT_USB_BAUD               9600

// Periodic Timers
#define CONFIG_UPDATE_INTERVAL_SECS    30
#define TIME_UPDATE_INTERVAL_SECS      30//86400 // Once per day

#if 1
//Enable debug
#define __DEBUG__
#include <cstdio>
#define DBG(x, ...) std::printf("[NTPClient : DBG]"x"\r\n", ##__VA_ARGS__); 
#define WARN(x, ...) std::printf("[NTPClient : WARN]"x"\r\n", ##__VA_ARGS__); 
#define ERR(x, ...) std::printf("[NTPClient : ERR]"x"\r\n", ##__VA_ARGS__); 

#else
//Disable debug
#define DBG(x, ...) 
#define WARN(x, ...)
#define ERR(x, ...) 
#endif

// TFTP Configuration Parameters
const char configName_enableAccess[] = "ENABLE";
const char configName_ipAddress[] = "IP";
const char configName_netMask[] = "MASK";
const char configName_gateway[] = "GATE";
const char configName_codeFileName[] = "CODEFILE";
const char configName_ntpServer[] = "NTPSRV";
const char configName_usbBaud[] = "BAUD";

bool config_enableAccess = 1;
char config_ipAddress[IP_STRING_MAX_LENGTH + 1] = "";
char config_netMask[IP_STRING_MAX_LENGTH + 1] = "";
char config_gateway[IP_STRING_MAX_LENGTH + 1] = "";
char config_codeFileName[CONFIG_PARAM_VALUE_MAX_LENGTH + 1] = "door-access-codes.cnf";
char config_tftpServer[IP_STRING_MAX_LENGTH + 1] = "0.0.0.0";
char config_ntpServer[IP_STRING_MAX_LENGTH + 1] = "0.0.0.0";
int config_usbBaud = DEFAULT_USB_BAUD;

enum ConfigUpdateSteps
{
    UPDATE_STEP_IDLE = -1,
    UPDATE_STEP_INITIATE = 0,
    UPDATE_STEP_CONFIG_FILE_REQUEST_SENT = 1,
    UPDATE_STEP_CONFIG_FILE_RECEIVED = 2,
    UPDATE_STEP_CODES_FILE_REQUEST_SENT = 3,
    UPDATE_STEP_CODES_FILE_RECEIVED = 4
};

class ConfigurationManager
{
public:
    ConfigurationManager(EthernetInterface* stack, CodeMemory* codeMem): mEth(stack), mCodeMem(codeMem), mUpdateStep(0), lastUpdatedConfigSeconds(0), lastUpdatedTimeSeconds(0){}
    void update();
    
private:
    void remove_all_chars(char* str, char c);
    bool isValidIpString(char* ip);
    int parse_tftp_config(char* data);
    int parse_tftp_codes(char* tftp_data);
    int connectEthernet(char* mac_addr, char* ip_addr, const bool withDhcp = true, const bool printStats = 1);
    void setupNetwork();
    void updateClock();
    
    EthernetInterface* mEth;
    CodeMemory* mCodeMem;
    char* _mac_addr;
    char* _ip_addr;
    NTPClient _ntp;
    TFTPClient* _tftp;
    char _tftp_data[MAX_TFTP_FILE_SIZE + 1];
    int mUpdateStep;
    // Periodic Timers
    time_t lastUpdatedConfigSeconds;
    time_t lastUpdatedTimeSeconds;
};

#endif