
#ifndef CODE_MEMORY_H_
#define CODE_MEMORY_H_

#include <algorithm>
#include "24LCxx_I2C/24LCxx_I2C.h"

#define EEPROM_LENGTH 1024
#define CODE_TABLE_SIZE 200 // bytes (codes * 2)
#define SPECIAL_CODE_TABLE_SIZE 20 // bytes (codes * 2)

#define EVENT_LOG_POINTER_SIZE 2 // bytes
#define EVENT_LOG_TIME_BASE_SIZE 4 // bytes
#define EVENT_SIZE 7 // bytes per event |1:event type|2:event value|4:ms timestamp|

// Event Types
#define EVENT_CARD_ACCESS_DENIED 1
#define EVENT_CARD_ACCESS_GRANTED 2
#define EVENT_KEYPAD_ACCESS_DENIED 3
#define EVENT_KEYPAD_ACCESS_GRANTED 4
#define EVENT_SPECIAL_CODE 5
#define EVENT_SPECIAL_CHANGE 6
#define EVENT_GATE_STATE_CHANGED 7 // 0 = Open, 1 = Closed
#define EVENT_ALARM_ACTIVE 8 // (Bit Array) 1:Power On, 2:East Tamper, 4:West Tamper, 8:Comms Loss
#define EVENT_ALARM_RESET 9

class CodeMemory
{
private:
    C24LCXX_I2C* _eeprom;

    int LogPointerAddress();
    int FirstEventLogAddress();
    int EventLogEndAddress();
    void PrintEvent(unsigned short eventAddress);
    int GetLatestEventAddress();
    int GetNextEventAddress();
    int GetNextEventAddress(unsigned short startAddress);
    int GetPreviousEventAddress(unsigned short startAddress);

public:
    CodeMemory(){_eeprom = new C24LCXX_I2C(D14, D15, 0, NC, 1000000);}
    ~CodeMemory(){delete _eeprom;}
    void EEPROMClear();
    unsigned short ReadAccessCode(unsigned short address);
    void WriteAccessCode(unsigned short address, unsigned short value);
    unsigned int ReadEEPROMULong(unsigned short address);
    void WriteEEPROMULong(unsigned short address, unsigned int value);
    int FindAccessCode(unsigned short code);
    int FindAccessCode(unsigned short code, unsigned short startAddress, unsigned short stopAddress);
    int ActivateAccessCode(unsigned short value);
    int DeactivateAccessCode(unsigned short value);
    void PrintAllAccessCodes();
    void SyncAccessCodes(unsigned short* codeList, unsigned short codeCount);
    bool IsSpecialCode(unsigned short specialCodeIndex, unsigned short code, unsigned short defaultCode);
    bool SetSpecialCode(unsigned short specialCodeIndex, unsigned short code);
    
    void WriteEvent(unsigned char eventType, unsigned short eventValue);
    void PrintEventLog();
    void PrintRecentEvents();
    void PrintRecentEvents(unsigned short numEvents);
};

#endif