/* TFTPClient.h */

/** \file
TFTP Client header file
*/

#ifndef TFTPCLIENT_H_
#define TFTPCLIENT_H_

#include <cstdint>
#include "EthernetInterface.h"
#include "NetworkStack.h"
#include "UDPSocket.h"
#include <inet.h>

using std::uint8_t;
using std::uint16_t;
using std::uint32_t;

#define TFTP_DEFAULT_PORT 69
#define TFTP_DEFAULT_TIMEOUT 4000
#define TFTP_MAX_DATA_SIZE 512
#define TFTP_MAX_PACKET_SIZE TFTP_MAX_DATA_SIZE+4
#define MAX_TFTP_FILE_SIZE 30000 // bytes

enum TFTPOpcode
{
  RRQ = 1, // Read request
  WRQ, // Write request
  DATA, // Data packet
  ACK, // Acknowledgement
  ERR // Error
};

enum TFTPError
{
    NOT_DEFINED, // Not defined, see error message (if any).
    FILE_NOT_FOUND, // File not found.
    ACCESS_VIOLATION, // Access violation.
    DISK_FULL, // Disk full or allocation exceeded.
    ILLEGAL_OP, // Illegal TFTP operation.
    UNKNOWN_TID, // Unknown transfer ID.
    FILE_EXISTS, // File already exists.
    NO_USER, // No such user.
};

class TFTPClient
{
public:
    TFTPClient(EthernetInterface *stack) : m_eth(stack){
        m_download_in_progress = false;
        m_tftp_addr = NULL;
    }
    
    /**Get current time (blocking)
    Retrieve file from TFTP server. Non-blocking
    @param host TFTP server IPv4 address or hostname (will be resolved via DNS)
    @param filename File to retrieve from the server.
    */
    bool readFile(char* data, const char* host, const char* filename, const uint16_t port = TFTP_DEFAULT_PORT, const uint32_t timeout = TFTP_DEFAULT_TIMEOUT);
    int update();

private:
    EthernetInterface *m_eth;
    UDPSocket m_sock;
    SocketAddress* m_tftp_addr;
    char* m_data;
    int m_bytes_sent;
    int m_bytes_received;
    int m_block_number;
    bool m_download_in_progress;
    int m_next_data_byte_index;
};

#endif /* TFTPCLIENT_H_ */

