
#ifndef DHCPOPTIONS_H_
#define DHCPOPTIONS_H_

#include <cstdint>
#include "EthernetInterface.h"
#include "NetworkStack.h"
#include "UDPSocket.h"
#include <inet.h>

using std::uint8_t;
using std::uint16_t;
using std::uint32_t;

#define MAC_STRING_LENGTH 17
#define DHCP_BROADCAST_ADDRESS "255.255.255.255"
#define DHCP_SERVER_PORT 67
#define DHCP_CLIENT_PORT 68
#define DHCP_DEFAULT_TIMEOUT 1000
#define DHCP_PACKET_SIZE 576

#define DHCP_OP_REQUEST 1 // Request op
#define DHCP_HTYPE 1 // Ethernet
#define DHCP_HLEN 6 // MAC 6 octet
#define DHCP_HOPS 0
#define DHCP_SECS 0
#define DHCP_FLAGS 0
#define DHCP_CIADDR 0
#define DHCP_YIADDR 0
#define DHCP_SIADDR 0
#define DHCP_GIADDR 0
#define DHCP_MAGIC_COOKIE 0x63825363 // See, it is magic after all!
#define DHCP_PREQLIST 55
#define DHCP_OPTION_TFTPSERVER 66
#define DHCP_OPTION_STOP 255

#define DHCP_CHADDR_SIZE      16
#define DHCP_SNAME_SIZE       64
#define DHCP_FILE_SIZE        128
#define DHCP_OPTIONS_SIZE     312

class DHCPOptions
{
public:
    DHCPOptions(EthernetInterface *stack) : m_eth(stack) {}

    /* Get DHCP Options from the server. Blocks until completion. */
    int getOptions(char* tftp_server, const char* mac_address, const uint32_t timeout = DHCP_DEFAULT_TIMEOUT); //Blocking

private:
    EthernetInterface *m_eth;
    UDPSocket m_sock;
    
    struct DHCPPacket
    {
        uint8_t op;
        uint8_t htype;
        uint8_t hlen;
        uint8_t hops;
        uint32_t xid;
        uint16_t secs;
        uint16_t flags;
        uint32_t ciaddr;
        uint32_t yiaddr;
        uint32_t siaddr;
        uint32_t giaddr;
        char chaddr[DHCP_CHADDR_SIZE];
        char sname[DHCP_SNAME_SIZE];
        char file[DHCP_FILE_SIZE];
        
        //Options
        uint32_t magic; // magic cookie
        uint8_t op_mtype; // message type
        uint8_t mtype_len;
        uint8_t mtype;
        char options[DHCP_OPTIONS_SIZE];
        
    } __attribute__ ((packed));
    
    int decodeOptions(char* tftp_server, DHCPPacket& pkt);
    int macStrToBin(char* macBin, const char* macStr);
    unsigned char charToNum(const char input);
};

#endif /* DHCPOPTIONS_H_ */

