/* mbed simplified access to Microchip 24LCxx Serial EEPROM devices (I2C)
 * Copyright (c) 2010-2012 ygarcia, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#if !defined(__24LCXX_I2C_H__)
#define __24LCXX_I2C_H__

#include "mbed.h"

namespace _24LCXX_I2C {
    class C24LCXX_I2C {
        /** Device address input: A0, A1, A2 (Pins <1,3>). See DS21203K/DS21189D - Figure 5-1: Control Byte Format for address format details
         */
        unsigned char _slaveAddress;
        /** WP state indicator (pin 7); true is write protected, false otherwise
         */
        DigitalOut *_wp;
        /** An unique instance of I2C class
         */
        I2C *_i2cInstance;
    public:
        /** Memory storage mode
         */
        enum Mode {
            LittleEndian, //<! Little Endian mode: 0xA0B70708 is stored as 08: MSB and A0 LSB
            BigEndian //<! Little Endian mode: 0xA0B70708 is stored as AO: MSB and 08 LSB
        };
    public:
        C24LCXX_I2C(const PinName p_sda, const PinName p_scl, const unsigned char p_address, const uint32_t p_frequency = 400000);
        virtual ~C24LCXX_I2C();

        bool Write(const uint16_t p_address, const uint8_t p_byte);
        bool Write(const uint16_t p_address, const uint16_t p_short, const C24LCXX_I2C::Mode p_mode = BigEndian);
        bool Write(const uint16_t p_address, const uint32_t p_int, const C24LCXX_I2C::Mode p_mode = BigEndian);
        bool Read(const uint16_t p_address, unsigned char *p_value);
        bool Read(const uint16_t p_address, uint16_t *p_short, C24LCXX_I2C::Mode p_mode = BigEndian);
        bool Read(const uint16_t p_address, uint32_t *p_int, C24LCXX_I2C::Mode p_mode = BigEndian);
        
    private:
    }; // End of class C24LCXX_I2C

} // End of namespace _24LCXX_I2C

using namespace _24LCXX_I2C;

#endif // __24LCXX_I2C_H__
