#include "mbed.h"
#include "BufferedSerial.h"
class JY901
{
    int state, token, payloadLen, recvLen;
    unsigned char payloadBuf[16];
protected:
    BufferedSerial mod;
    float acc[3], gyo[3], mag[3], att[3];
    void parseCmpt(int token, unsigned char* payloadBuf, int payloadLen);
    void parseInput(const char* data, int len);
public:
    JY901(PinName TX, PinName RX) : mod(TX, RX, 32){}
    ~JY901() {}
    void receiveData();
    void getAcc(float &x, float &y, float &z){
        x = acc[0];
        y = acc[1];
        z = acc[2];
    }
    void getGyo(float &x, float &y, float &z){
        x = gyo[0];
        y = gyo[1];
        z = gyo[2];
    }
    void getMag(float &x, float &y, float &z){
        x = mag[0];
        y = mag[1];
        z = mag[2];
    }
    void getAttitude(float &roll, float &pitch, float &yaw){
        roll = att[0];
        pitch = att[1];
        yaw = att[2];
    }
};