#include "mbed.h"
#include "nRF24L01P.h"

Serial pc(USBTX, USBRX, 115200); // tx, rx

//                 mosi, miso, sck, csn, ce, irq
nRF24L01P my_nrf24l01p(D4, D5, D3, D7, D8, D6);

// The nRF24L01+ supports transfers from 1 to 32 bytes
#define TRANSFER_SIZE   1

void initNrf24L01()
{
    my_nrf24l01p.powerUp();

    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
}
int main() {
    char data[TRANSFER_SIZE];
    initNrf24L01();
    while (1) {
        // If we've received anything in the nRF24L01+...
        if ( my_nrf24l01p.readable() ) {
            // ...read the data into the receive buffer
            my_nrf24l01p.read( NRF24L01P_PIPE_P0, data, TRANSFER_SIZE);
            pc.putc(data[0]);
        }
        if ( pc.readable() ) {
            data[0] = pc.getc();
            // Send the transmitbuffer via the nRF24L01+
            my_nrf24l01p.write( NRF24L01P_PIPE_P0, data, TRANSFER_SIZE );
        }
    }
}
