#include "I2C.h"
#include"mbed.h"

void Delay(u32 count){while (count--);}
void SDA_IN(){sda.input();}
void SDA_OUT(){sda.output();}
void IIC_SCL(int a = 0){scl.write(a);}
void IIC_SDA(int a = 0){sda.write(a);}
int READ_SDA(){return sda.read();}
void IIC_Init()
{    
    SDA.mode(OpenDrain);
    SCL.mode(OpenDrain);        
    SDA_OUT();
    IIC_SDA(1);        
    IIC_SCL(1);
}
void IIC_Start(void)
{
    SDA_OUT();     //sdaÏßÊä³ö
    IIC_SDA();        
    IIC_SCL();
    
    Delay(5);
    IIC_SDA(0);//START:when CLK is high,DATA change form high to low 
    
    Delay(5);
    IIC_SCL(0);//Ç¯×¡I2C×ÜÏß£¬×¼±¸·¢ËÍ»ò½ÓÊÕÊý¾Ý 
}

/**************************ÊµÏÖº¯Êý********************************************
*º¯ÊýÔ­ÐÍ:      void IIC_Stop(void)
*¹¦¡¡¡¡ÄÜ:      //²úÉúIICÍ£Ö¹ÐÅºÅ
*******************************************************************************/      
void IIC_Stop(void)
{
    SDA_OUT();//sdaÏßÊä³ö
    IIC_SCL(0);
    IIC_SDA(0);//STOP:when CLK is high DATA change form low to high
    
        Delay(5);
    IIC_SCL(1); 
    IIC_SDA(1);//·¢ËÍI2C×ÜÏß½áÊøÐÅºÅ
    
        Delay(5);                               
}

/**************************ÊµÏÖº¯Êý********************************************
*º¯ÊýÔ­ÐÍ:      unsigned char IIC_Wait_Ack(void)
*¹¦¡¡¡¡ÄÜ:      µÈ´ýÓ¦´ðÐÅºÅµ½À´ 
//·µ»ØÖµ£º1£¬½ÓÊÕÓ¦´ðÊ§°Ü
//        0£¬½ÓÊÕÓ¦´ð³É¹¦
*******************************************************************************/
unsigned char IIC_Wait_Ack(void)
{
    unsigned char ucErrTime=0; 
    SDA_IN();      //SDAÉèÖÃÎªÊäÈë  
    IIC_SDA(1);
        Delay(5);     
    while(READ_SDA)
    {
        ucErrTime++;
        if(ucErrTime>50)
        {
            IIC_Stop();
            return 1;
        }
        Delay(5);
    }  
    IIC_SCL(1);
    Delay(5); 
    IIC_SCL(0);//Ê±ÖÓÊä³ö0  
    return 0;  
} 

/**************************ÊµÏÖº¯Êý********************************************
*º¯ÊýÔ­ÐÍ:      void IIC_Ack(void)
*¹¦¡¡¡¡ÄÜ:      ²úÉúACKÓ¦´ð
*******************************************************************************/
void IIC_Ack(void)
{
    IIC_SCL(0);
    SDA_OUT();
    IIC_SDA(0);
        Delay(5);
    IIC_SCL(1);
        Delay(5);
    IIC_SCL(0);
}
    
/**************************ÊµÏÖº¯Êý********************************************
*º¯ÊýÔ­ÐÍ:      void IIC_NAck(void)
*¹¦¡¡¡¡ÄÜ:      ²úÉúNACKÓ¦´ð
*******************************************************************************/        
void IIC_NAck(void)
{
    IIC_SCL(0);
    SDA_OUT();
    IIC_SDA(0);
    
        Delay(5);
    IIC_SCL(1);
        Delay(5);
    IIC_SCL(1);
}                                        

/**************************ÊµÏÖº¯Êý********************************************
*º¯ÊýÔ­ÐÍ:      void IIC_Send_Byte(unsigned char txd)
*¹¦¡¡¡¡ÄÜ:      IIC·¢ËÍÒ»¸ö×Ö½Ú
*******************************************************************************/          
void IIC_Send_Byte(unsigned char txd)
{                        
    unsigned char t; 
        SDA_OUT();      
    IIC_SCL(0);//À­µÍÊ±ÖÓ¿ªÊ¼Êý¾Ý´«Êä
    for(t=0;t<8;t++)
    {              
        IIC_SDA=(txd&0x80)>>7;
        txd<<=1;      
            
        Delay(2);   
        IIC_SCL(1);
        Delay(5);
        IIC_SCL(0);  
        Delay(3);
    }    
}    
   
/**************************ÊµÏÖº¯Êý********************************************
*º¯ÊýÔ­ÐÍ:      unsigned char IIC_Read_Byte(unsigned char ack)
*¹¦¡¡¡¡ÄÜ:      //¶Á1¸ö×Ö½Ú£¬ack=1Ê±£¬·¢ËÍACK£¬ack=0£¬·¢ËÍnACK 
*******************************************************************************/  
unsigned char IIC_Read_Byte(unsigned char ack)
{
    unsigned char i,receive=0;
    SDA_IN();//SDAÉèÖÃÎªÊäÈë
    for(i=0;i<8;i++ )
    {
        IIC_SCL(0); 
        
        Delay(5);
        IIC_SCL(1);
        receive<<=1;
        if(READ_SDA)receive++;   
        
        Delay(5); 
    }                    
    if (ack)
        IIC_Ack(); //·¢ËÍACK 
    else
        IIC_NAck();//·¢ËÍnACK  
    return receive;
}

/**************************ÊµÏÖº¯Êý********************************************
*º¯ÊýÔ­ÐÍ:      unsigned char IICreadBytes(unsigned char dev, unsigned char reg, unsigned char length, unsigned char *data)
*¹¦¡¡¡¡ÄÜ:      ¶ÁÈ¡Ö¸¶¨Éè±¸ Ö¸¶¨¼Ä´æÆ÷µÄ length¸öÖµ
ÊäÈë    dev  Ä¿±êÉè±¸µØÖ·
        reg   ¼Ä´æÆ÷µØÖ·
        length Òª¶ÁµÄ×Ö½ÚÊý
        *data  ¶Á³öµÄÊý¾Ý½«Òª´æ·ÅµÄÖ¸Õë
·µ»Ø   ¶Á³öÀ´µÄ×Ö½ÚÊýÁ¿
*******************************************************************************/ 
unsigned char IICreadBytes(unsigned char dev, unsigned char reg, unsigned char length, unsigned char *data){
    unsigned char count = 0;
    
    IIC_Start();
    IIC_Send_Byte(dev<<1);     //·¢ËÍÐ´ÃüÁî
    IIC_Wait_Ack();
    IIC_Send_Byte(reg);   //·¢ËÍµØÖ·
  IIC_Wait_Ack();     
    IIC_Start();
    IIC_Send_Byte((dev<<1)+1);  //½øÈë½ÓÊÕÄ£Ê½  
    IIC_Wait_Ack();
    
    for(count=0;count<length;count++){
         
         if(count!=length-1)data[count]=IIC_Read_Byte(1);  //´øACKµÄ¶ÁÊý¾Ý
            else  data[count]=IIC_Read_Byte(0);  //×îºóÒ»¸ö×Ö½ÚNACK
    }
    IIC_Stop();//²úÉúÒ»¸öÍ£Ö¹Ìõ¼þ
    return count;
}

/**************************ÊµÏÖº¯Êý********************************************
*º¯ÊýÔ­ÐÍ:      unsigned char IICwriteBytes(unsigned char dev, unsigned char reg, unsigned char length, unsigned char* data)
*¹¦¡¡¡¡ÄÜ:      ½«¶à¸ö×Ö½ÚÐ´ÈëÖ¸¶¨Éè±¸ Ö¸¶¨¼Ä´æÆ÷
ÊäÈë    dev  Ä¿±êÉè±¸µØÖ·
        reg   ¼Ä´æÆ÷µØÖ·
        length ÒªÐ´µÄ×Ö½ÚÊý
        *data  ½«ÒªÐ´µÄÊý¾ÝµÄÊ×µØÖ·
·µ»Ø   ·µ»ØÊÇ·ñ³É¹¦
*******************************************************************************/ 
unsigned char IICwriteBytes(unsigned char dev, unsigned char reg, unsigned char length, unsigned char* data){
  
    unsigned char count = 0;
    IIC_Start();
    IIC_Send_Byte(dev<<1);     //·¢ËÍÐ´ÃüÁî
    IIC_Wait_Ack();
    IIC_Send_Byte(reg);   //·¢ËÍµØÖ·
    IIC_Wait_Ack();   
    for(count=0;count<length;count++){
        IIC_Send_Byte(data[count]); 
        IIC_Wait_Ack(); 
 }
    IIC_Stop();//²úÉúÒ»¸öÍ£Ö¹Ìõ¼þ

    return 1; //status == 0;
    
}