
#include "mbed.h"
#include "figuras.h"

SPI deviceM(PB_15, PB_14, PB_13);
DigitalOut ssel (PB_12);
Serial command(USBTX, USBRX);

#define DEBUG 1
#define  VELOCITY 200 // ms



uint8_t matrix_act[8]={0,0,0,0,0,0,0,0};
uint8_t matrix_tmp[11]={0b00000000,0b00000000,0b00000000,0,0,0,0,0,0,0};
uint8_t array[3]={0,0,0};
int lim=0;
void debug_m(char *s , ... ){
    #if DEBUG
    command.printf(s);
    #endif  
}


uint32_t recibe (void)
{
    char ini=command.getc();
    while(ini!='<')
    ini=command.getc();
    
    for(int i=0;i<3;i++)
    {
    array[i]=command.getc();
    }
    
   ini=command.getc();
    while(ini!='>')
    {
      debug_m("xx");
      return 0;
      
    }
     debug_m("yy");
    return 1; 
   
    }  
 
void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);  
    ssel=1;
    deviceM.lock();
};

void imp_fig(){
    int i=0;
    for(i=0;i<=lim;i++){
        sendSPI(i-2,0);
        sendSPI(i-1,matrix_tmp[0]);
        sendSPI(i,matrix_tmp[1]);
        sendSPI(i+1,matrix_tmp[2]);
        wait_ms(VELOCITY);
        }
    }


void printMatrix(uint8_t*  vC)

{
    uint8_t i =0;
    for (i=1;i<9;i++){
        sendSPI(i,*(vC+i-1));
    }
        
    }


void init_display(){
    sendSPI(0x0c,1);
    sendSPI(0x0b,7);
    sendSPI(0x09,0);
    sendSPI(0x0A,0x0E);
    printMatrix(matrix_act);
    int i;
    for (i=0;i<4;i++){
        sendSPI(0x0F,1);
        wait (0.2);
        sendSPI(0x0f,0);
        wait (0.2);
    }
}



 
 
void act_matrix(uint8_t*  mascara){
    int newm[8]={0,0,0,0,0,0,0,0}; 
        for (int i=0; i<8;i++)
    {   
        newm[i]=mascara[i]| matrix_act[i];
        matrix_act[i]=  ( *(newm+i));
     }  
    for (int i=0; i<8;i++)
    {   
        newm[i]=mascara[i]| matrix_act[i];
     }   
 
 } 
 
 void copy_matrix(uint8_t*  m2, char col){
  
    for (int i=0; i<11;i++){
        matrix_tmp[i]=  (*(m2+i)>>(col-1));
    }
 } 

    
    
void new_read(){
    switch (array[0]) {
    case  L_TYPE: 
    switch (array[1])
         {  case NOVEN: 
         lim=8;
             switch(array[2])
             {case 1:
             copy_matrix(FIG_L1,1);
             break;
             case 2:
             copy_matrix(FIG_L1,2);
             break;
             case 3:
             copy_matrix(FIG_L1,3);
             break;
             case 4:
             copy_matrix(FIG_L1,4);
             break;
             case 5:
             copy_matrix(FIG_L1,5);
             break;
             case 6:
             copy_matrix(FIG_L1,6);
             break;
             case 7:
             copy_matrix(FIG_L1,6);
             break;
             case 8:
             copy_matrix(FIG_L1,6);
             break;
            }
            break;
            case ZERO:
            lim=7;
            switch(array[2])
             {case 1:
             copy_matrix(FIG_L,1);
             break;
             case 2:
             copy_matrix(FIG_L,2);
             break;
             case 3:
             copy_matrix(FIG_L,3);
             break;
             case 4:
             copy_matrix(FIG_L,4);
             break;
             case 5:
             copy_matrix(FIG_L,5);
             break;
             case 6:
             copy_matrix(FIG_L,6);
             break;
             case 7:
             copy_matrix(FIG_L,7);
             break;
             case 8:
             copy_matrix(FIG_L,7);
             break;
            }
            
        break ; 
        case PII:
            lim=7;
            switch(array[2])
             {case 1:
             copy_matrix(FIG_L2,1);
             break;
             case 2:
             copy_matrix(FIG_L2,2);
             break;
             case 3:
             copy_matrix(FIG_L2,3);
             break;
             case 4:
             copy_matrix(FIG_L2,4);
             break;
             case 5:
             copy_matrix(FIG_L2,5);
             break;
             case 6:
             copy_matrix(FIG_L2,6);
             break;
             case 7:
             copy_matrix(FIG_L2,7);
             break;
             case 8:
             copy_matrix(FIG_L2,7);
             break;
            }
            break;
            case DOSSE:
            lim=8;
            switch(array[2])
             {case 1:
             copy_matrix(FIG_L3,1);
             break;
             case 2:
             copy_matrix(FIG_L3,2);
             break;
             case 3:
             copy_matrix(FIG_L3,3);
             break;
             case 4:
             copy_matrix(FIG_L3,4);
             break;
             case 5:
             copy_matrix(FIG_L3,5);
             break;
             case 6:
             copy_matrix(FIG_L3,6);
             break;
             case 7:
             copy_matrix(FIG_L3,6);
             break;
             case 8:
             copy_matrix(FIG_L3,6);
             break;
            }
            break; 
        }
                break ;     
    case  S_TYPE: 
        switch (array[1])
         {  case NOVEN:
         lim=7;
            switch(array[2])
             {case 1:
             copy_matrix(FIG_S1,1);
             break;
             case 2:
             copy_matrix(FIG_S1,2);
             break;
             case 3:
             copy_matrix(FIG_S1,3);
             break;
             case 4:
             copy_matrix(FIG_S1,4);
             break;
             case 5:
             copy_matrix(FIG_S1,5);
             break;
             case 6:
             copy_matrix(FIG_S1,6);
             break;
             case 7:
             copy_matrix(FIG_S1,7);
             break;
             case 8:
             copy_matrix(FIG_S1,7);
             break;
            }
            break;
            case ZERO:
            lim=8;
            switch(array[2])
             {case 1:
             copy_matrix(FIG_S,1);
             break;
             case 2:
             copy_matrix(FIG_S,2);
             break;
             case 3:
             copy_matrix(FIG_S,3);
             break;
             case 4:
             copy_matrix(FIG_S,4);
             break;
             case 5:
             copy_matrix(FIG_S,5);
             break;
             case 6:
             copy_matrix(FIG_S,6);
             break;
             case 7:
             copy_matrix(FIG_S,6);
             break;
             case 8:
             copy_matrix(FIG_S,6);
             break;
            }
        break ; 
        case PII:
        lim=8;
            switch(array[2])
             {case 1:
             copy_matrix(FIG_S2,1);
             break;
             case 2:
             copy_matrix(FIG_S2,2);
             break;
             case 3:
             copy_matrix(FIG_S2,3);
             break;
             case 4:
             copy_matrix(FIG_S2,4);
             break;
             case 5:
             copy_matrix(FIG_S2,5);
             break;
             case 6:
             copy_matrix(FIG_S2,6);
             break;
             case 7:
             copy_matrix(FIG_S2,6);
             break;
             case 8:
             copy_matrix(FIG_S2,6);
             break;
            }
            break;
            case DOSSE:
            lim=7;
            switch(array[2])
             {case 1:
             copy_matrix(FIG_S3,1);
             break;
             case 2:
             copy_matrix(FIG_S3,2);
             break;
             case 3:
             copy_matrix(FIG_S3,3);
             break;
             case 4:
             copy_matrix(FIG_S3,4);
             break;
             case 5:
             copy_matrix(FIG_S3,5);
             break;
             case 6:
             copy_matrix(FIG_S3,6);
             break;
             case 7:
             copy_matrix(FIG_S3,7);
             break;
             case 8:
             copy_matrix(FIG_S3,7);
             break;
            }
            break; 
        }
        break ;     
    case  I_TYPE: 
        switch (array[1])
         {  
         case NOVEN:
         lim=8;
            switch(array[2])
             {case 1:
             copy_matrix(FIG_I1,1);
             break;
             case 2:
             copy_matrix(FIG_I1,2);
             break;
             case 3:
             copy_matrix(FIG_I1,3);
             break;
             case 4:
             copy_matrix(FIG_I1,4);
             break;
             case 5:
             copy_matrix(FIG_I1,5);
             break;
             case 6:
             copy_matrix(FIG_I1,6);
             break;
             case 7:
             copy_matrix(FIG_I1,6);
             break;
             case 8:
             copy_matrix(FIG_I1,6);
             break;
            }
            break;
            case ZERO:
            lim=7; 
            switch(array[2])
             {case 1:
             copy_matrix(FIG_I,1);
             break;
             case 2:
             copy_matrix(FIG_I,2);
             break;
             case 3:
             copy_matrix(FIG_I,3);
             break;
             case 4:
             copy_matrix(FIG_I,4);
             break;
             case 5:
             copy_matrix(FIG_I,5);
             break;
             case 6:
             copy_matrix(FIG_I,6);
             break;
             case 7:
             copy_matrix(FIG_I,7);
             break;
             case 8:
             copy_matrix(FIG_I,8);
             break;
            }
        break ; 
        case PII:
        lim=7;
            switch(array[2])
             {case 1:
             copy_matrix(FIG_I2,1);
             break;
             case 2:
             copy_matrix(FIG_I2,2);
             break;
             case 3:
             copy_matrix(FIG_I2,3);
             break;
             case 4:
             copy_matrix(FIG_I2,4);
             break;
             case 5:
             copy_matrix(FIG_I2,5);
             break;
             case 6:
             copy_matrix(FIG_I2,6);
             break;
             case 7:
             copy_matrix(FIG_I2,7);
             break;
             case 8:
             copy_matrix(FIG_I2,8);
             break;
            }
            break;
            case DOSSE:
            lim=8;
            switch(array[2])
             {case 1:
             copy_matrix(FIG_I3,1);
             break;
             case 2:
             copy_matrix(FIG_I3,2);
             break;
             case 3:
             copy_matrix(FIG_I3,3);
             break;
             case 4:
             copy_matrix(FIG_I3,4);
             break;
             case 5:
             copy_matrix(FIG_I3,5);
             break;
             case 6:
             copy_matrix(FIG_I3,6);
             break;
             case 7:
             copy_matrix(FIG_I3,6);
             break;
             case 8:
             copy_matrix(FIG_I3,6);
             break;
            }
            break;
        }
        break ;     
    case  C_TYPE: 
        lim=8;
        switch(array[2])
             {case 1:
             copy_matrix(FIG_C,1);
             break;
             case 2:
             copy_matrix(FIG_C,2);
             break;
             case 3:
             copy_matrix(FIG_C,3);
             break;
             case 4:
             copy_matrix(FIG_C,4);
             break;
             case 5:
             copy_matrix(FIG_C,5);
             break;
             case 6:
             copy_matrix(FIG_C,6);
             break;
             case 7:
             copy_matrix(FIG_C,7);
             break;
             case 8:
             copy_matrix(FIG_C,8);
             break;
            }
        break ; 
    case  T_TYPE:
         switch (array[1])
         {  case NOVEN:
         lim=7;
            switch(array[2])
             {case 1:
             copy_matrix(FIG_T1,1);
             break;
             case 2:
             copy_matrix(FIG_T1,2);
             break;
             case 3:
             copy_matrix(FIG_T1,3);
             break;
             case 4:
             copy_matrix(FIG_T1,4);
             break;
             case 5:
             copy_matrix(FIG_T1,5);
             break;
             case 6:
             copy_matrix(FIG_T1,6);
             break;
             case 7:
             copy_matrix(FIG_T1,7);
             break;
             case 8:
             copy_matrix(FIG_T1,7);
             break;
            }
            break;
            case ZERO:
            lim=8;
            switch(array[2])
             {case 1:
             copy_matrix(FIG_T,1);
             break;
             case 2:
             copy_matrix(FIG_T,2);
             break;
             case 3:
             copy_matrix(FIG_T,3);
             break;
             case 4:
             copy_matrix(FIG_T,4);
             break;
             case 5:
             copy_matrix(FIG_T,5);
             break;
             case 6:
             copy_matrix(FIG_T,6);
             break;
             case 7:
             copy_matrix(FIG_T,6);
             break;
             case 8:
             copy_matrix(FIG_T,6);
             break;
            }
        break ; 
        case PII:
        lim=8;
            switch(array[2])
             {case 1:
             copy_matrix(FIG_T2,1);
             break;
             case 2:
             copy_matrix(FIG_T2,2);
             break;
             case 3:
             copy_matrix(FIG_T2,3);
             break;
             case 4:
             copy_matrix(FIG_T2,4);
             break;
             case 5:
             copy_matrix(FIG_T2,5);
             break;
             case 6:
             copy_matrix(FIG_T2,6);
             break;
             case 7:
             copy_matrix(FIG_T2,6);
             break;
             case 8:
             copy_matrix(FIG_T2,6);
             break;
            }
            break;
            case DOSSE:
            lim=7;
            switch(array[2])
             {case 1:
             copy_matrix(FIG_T3,1);
             break;
             case 2:
             copy_matrix(FIG_T3,2);
             break;
             case 3:
             copy_matrix(FIG_T3,3);
             break;
             case 4:
             copy_matrix(FIG_T3,4);
             break;
             case 5:
             copy_matrix(FIG_T3,5);
             break;
             case 6:
             copy_matrix(FIG_T3,6);
             break;
             case 7:
             copy_matrix(FIG_T3,7);
             break;
             case 8:
             copy_matrix(FIG_T3,7);
             break;
            }
            break; 
        }
        break;
    default: 
        copy_matrix(FIG_NULL,1);
        break;
        }
        
}
//desplazamiento horizontal
void desplazar_fila(){
    for (int i=0; i<8;i++)
        matrix_tmp[i]= matrix_tmp[i]>>1;
    
    }

int main() {
    init_display();
    debug_m("inicio");
    while(1){
       while(recibe()==0);
       new_read();
            act_matrix(matrix_tmp);
            imp_fig(); 
       } 
    }
