#include "mbed.h"
#include "figs.h" 

Ticker bajar;
SPI deviceM(PB_15, PB_14, PB_13);
DigitalOut ssel (PB_12);
Serial command(USBTX,USBRX);
AnalogIn joy(A0);
AnalogIn joy1(A1); 
float vx=0;
float vy=0;
DigitalIn cambio(PB_8);
int cc=0, punto=1;
uint8_t movimiento=0;

float VEL= 500; 

uint8_t matrix_act [11]={0,0,0,0,0,0,0,0,0,0,0};   
uint8_t matrix_temp [8]={0,0,0,0,0,0,0,0};    
uint8_t matrix_temp1[8]={0,0,0,0,0,0,0,0};
uint8_t fila=1,cont=0,columna=1,rotacion=1,figura=0;
 
void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);
    ssel=1;
    deviceM.lock();
}



void init_display()
{
    sendSPI(0x0c,1);
    sendSPI(0x0b,7);
    sendSPI(0x09,0);
    sendSPI(0x0A,0x0E);
    int j;
    for (j=0;j<4;j++){
        sendSPI(0x0F,1);
        wait (0.2);
        sendSPI(0x0f,0);
        wait (0.2);
    }   
}

void copy_matrix(uint8_t a,uint8_t b,uint8_t c,uint8_t* fig,uint8_t columna)
{       
        if(((matrix_act[cont-2]& *(fig+c)>>columna-1)==0)&&((matrix_act[cont-1]& *(fig+b)>>columna-1)==0)&&((matrix_act[cont]& *(fig+a)>>columna-1)==0)){
                    matrix_temp[0]= *(fig+5)>>columna-1;             
                    matrix_temp[1]= *(fig+a)>>columna-1;            
                    matrix_temp[2]= *(fig+b)>>columna-1;
                    matrix_temp[3]= *(fig+c)>>columna-1;
        }   
}

void borrar()            
{
    int i;
    for(i=0;i<=8;i++)
    {
        sendSPI(i,0);
        matrix_act[i]=0;   
    }
};

void game_over()
{
    uint8_t go [9]={0,0,0b01000010,0b00100100,0b00011000,0b00100100,0b01000010,0b00000000,0}; 
    int k,n;
    for(n=0;n<6;n++)
    {
    borrar();
    for(k=1;k<=8;k++)
    {
    sendSPI(k,go[k]);
    }
    wait(0.2);
    borrar();
    wait(0.2);
    }
    }
    

void buscar_fila(){
    for (uint8_t i=0;i<9;i++){                     
        if((matrix_act[i]& matrix_temp[3])==0){
        fila=i;
        }
        if(((matrix_act[i]& matrix_temp[3])!=0)&& (i!=9)){
        fila=i-1;  
        command.printf("Fila pos 1: %d \n", fila);                                
        i=9;
        }
        if(((matrix_act[i]& matrix_temp[2])!=0)&& (i!=9)){           
        fila=i;                                   
        i=9;
        command.printf("Fila pos 2: %d \n", fila);
        }
        if(((matrix_act[i]& matrix_temp[1])!=0)&& (i!=9)){
        fila=i+1;                                 
        i=9;
        command.printf("Fila pos 3: %d \n", fila);
        }
    }
    if(fila>8)
        fila=8;
    if(fila<=1){
        punto=1;
        VEL=500;
        wait_ms(VEL);
        game_over();
        borrar();
        fila=8;
    }
};

void guardar(){
        matrix_act[fila-3]=matrix_temp1[0];
        matrix_act[fila-2]=matrix_temp1[1];
        matrix_act[fila-1]=matrix_temp1[2];
        matrix_act[fila  ]=matrix_temp1[3];
        };
    
void reada()
{    vx=0;
     vy=0;
     vx=joy.read();
     vy=joy1.read();
     cc=cambio.read();
    }
    
void bajaf()
{
    movimiento=4;}
void movimiento_fig(){
    reada();
    command.printf("vy = %f \n", vy);
    command.printf("vx = %f \n", vx);
    command.printf("cc = %f \n", cambio.read());
   if(vy<0.2)  
    movimiento=1;
    if(vy>0.8)  
    movimiento=4;
    if(vx<0.2)
    movimiento=3;
    if(vx>0.80) 
    movimiento=2;
    command.printf("movimiento = %d \n", movimiento);
    switch (movimiento){
                
                case 4:
                cont++;
                //printf("%f", joy.read());
                if(cont>8)cont=8;
                break;                                            
                
                case 1:
                if( (matrix_temp[1]==2) || (matrix_temp[1]==1)|| (matrix_temp[1]==3)) 
                columna--;
                rotacion++;
                if(rotacion>4)
                rotacion=1;
                break; 
                
                 case 2:
                if((matrix_temp[2]==7 || matrix_temp[3]==7)||(matrix_temp[2]==3 && matrix_temp[3]==6)) {
                    command.printf("a");
                    columna=6;
                    }
                else if((matrix_temp[1]==2 && matrix_temp[2]==2 && matrix_temp[3]==2)){
                    command.printf("b");
                    columna=8;
                    }
                else if (columna<7){
                    command.printf("c");
                    columna++;
                    }
                    //printf("%f", joy1.read());
                break;        
            
                case 3:
                columna--;
                if(columna<1)
                columna=1;
                //printf("%f", joy.read());
                break;                                       
                                                        
    }
    }


void print_matrix(uint8_t *temp){
            matrix_temp1[0]=(matrix_temp[0]+ matrix_act[cont-3]);
            matrix_temp1[1]=(matrix_temp[1]+ matrix_act[cont-2]);
            matrix_temp1[2]=(matrix_temp[2]+ matrix_act[cont-1]);
            matrix_temp1[3]=(matrix_temp[3]+ matrix_act[cont]);                              
            sendSPI(cont-3,matrix_temp1[0]);
            sendSPI(cont-2,matrix_temp1[1]);
            sendSPI(cont-1,matrix_temp1[2]);
            sendSPI(cont  ,matrix_temp1[3]);                     //pasa de i+2 a i+1
            if(punto%4==0)
            {
            VEL=VEL/3;
             if(VEL<=50)
             VEL=50;   
                }
            wait_ms(VEL);
}

void crear_fig(char type_fig,char rotacion,char columna)
{    
    switch (type_fig){                  
        case 1: if(columna>7)
                columna=7;
                copy_matrix(5,1,1,PLANT,columna); break;  
        
        case 2: if(rotacion==1 || rotacion==3)              
                copy_matrix(0,0,0,PLANT,columna);
                if(rotacion==2 || rotacion==4)
                copy_matrix(5,5,2,PLANT,columna);         
                break;
                  
        case 3: if(rotacion==1)
                copy_matrix(0,0,1,PLANT,columna);        
                if(rotacion==2)
                copy_matrix(5,2,0,PLANT,columna);
                if(rotacion==3)
                copy_matrix(1,3,3,PLANT,columna);
                if(rotacion==4)
                copy_matrix(5,6,2,PLANT,columna);
                break;
        
        case 4: if(rotacion==1)
                copy_matrix(5,3,2,PLANT,columna);        
                if(rotacion==2)
                copy_matrix(0,1,0,PLANT,columna);
                if(rotacion==3)
                copy_matrix(5,2,3,PLANT,columna);
                if(rotacion==4)
                copy_matrix(3,1,3,PLANT,columna);
                break;
        
        case 5: if(rotacion==1 || rotacion==3)
                copy_matrix(5,4,1,PLANT,columna);   
                if(rotacion==2 || rotacion==4)
                copy_matrix(0,1,3,PLANT,columna);
                break; 
    }  
}

void figuras(){
    figura= rand() % 5+1; 
    rotacion= rand() % 4+1;
    columna= 4; 
    }
    
void elimina_linea(){
   for(uint8_t i=0;i<9;i++){
        if(matrix_act[i]==255){
            for(uint8_t a=i;a>=1;a--){
                sendSPI(a,matrix_act[a-1]);
                matrix_act[a]=matrix_act[a-1];
            }
            punto++;
            printf("%f", punto);
        }
    }
}

int main() {
    bajar.attach(&bajaf, 0.1);
    init_display();
    borrar();
    while(1){
            figuras();
            buscar_fila();
            cont=0; 
            elimina_linea();
            while (cont<fila){
                        movimiento_fig();    
                        crear_fig(figura,rotacion,columna);
                        buscar_fila();
                        print_matrix(matrix_temp);
                        }          
            guardar();
        }
    }